# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import gtk, gobject
from gettext import gettext as _

from cohoba.common.Utils import load_icon, global_error_handler
from cohoba.common.DBusProxyProvider import get_proxy_provider
from cohoba.common.ui.PresenceIcons import get_presence_icons
from cohoba.common.DBusProxyProvider import get_proxy_provider
from cohoba.common.TelepathyConstants import (MISSION_CONTROL_INTERFACE,
	MISSION_CONTROL_OBJECT_PATH, MISSION_CONTROL_BUS_NAME)

class PresenceComboBoxModel(gtk.ListStore):
	COL_PIXBUF = 0
	COL_TEXT = 1
	COL_NAME = 2
	
	def __init__(self):
		gtk.ListStore.__init__(self, gtk.gdk.Pixbuf, gobject.TYPE_STRING, gobject.TYPE_STRING)
				
		presences = [
			("available", _("Available")),
			("away", _("Away")),
#			("brb", _("Be Right Back")),
#			("busy", _("Busy")),
			("dnd", _("Do Not Disturb")),
			("xa", _("Extended Away")),
			("hidden", _("Invisible")),
			("offline", _("Offline")),
		]
		
		for name, text in presences:
			self.append([get_presence_icons(name)[0], text, name])
	
	def get_iter_for_name(self, name):
		for row in self:
			if row[2] == name:
				return row.iter
				
class PresenceComboBox(gtk.ComboBox):
	
	__gsignals__ = {
		"presence": (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [gobject.TYPE_STRING, gobject.TYPE_STRING]),
	}
	
	def __init__(self, message_entry):
		gtk.ComboBox.__init__(self, PresenceComboBoxModel())
		
		self.message_entry = message_entry
		
		cell = gtk.CellRendererPixbuf()
		self.pack_start(cell, False)
		self.add_attribute(cell, 'pixbuf', 0)
		
		cell = gtk.CellRendererText()
		self.pack_start(cell, True)
		self.add_attribute(cell, 'text', 1)
		
		self.connect('changed', self.on_presence_change)
		self.message_entry.connect('activate', self.on_presence_change)
		self.message_entry.connect('focus-out-event', self.on_presence_change)
		
		get_proxy_provider().create_proxy(
			MISSION_CONTROL_BUS_NAME,
			MISSION_CONTROL_OBJECT_PATH)
			
		self.mission_control_iface = get_proxy_provider().get_iface(
			MISSION_CONTROL_OBJECT_PATH,
			MISSION_CONTROL_INTERFACE)
		
		self.mission_control_iface.GetPresence(reply_handler=self.got_mc_presence, error_handler=global_error_handler)
	
	def got_mc_presence(self, name, message):
		iter = self.get_model().get_iter_for_name(name)
		if iter != None:
			self.set_active_iter(iter)
		self.message_entry.set_text(message)
		
	def on_presence_change(self, widget, event=None):
		if self.get_active_iter() == None:
			return
			
		name = self.get_model()[self.get_active_iter()][PresenceComboBoxModel.COL_NAME]
		message = self.message_entry.get_text()
		
		self.mission_control_iface.SetPresence(name, message, reply_handler=lambda: None, error_handler=global_error_handler)		
