# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import gobject
from cohoba.common.PyListStore import PyListStore
from cohoba.common.Account import Account
from cohoba.common.DBusProxyProvider import get_proxy_provider
from cohoba.common.Utils import global_error_handler
from cohoba.common.TelepathyConstants import (MISSION_CONTROL_INTERFACE,
	MISSION_CONTROL_OBJECT_PATH, MISSION_CONTROL_BUS_NAME)

class AccountList(PyListStore):
	__gsignals__ = {
		"accounts-received" : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, []),
	}
	def __init__(self):
		PyListStore.__init__(self)
		
		mission_control_iface = get_proxy_provider().get_iface(
			MISSION_CONTROL_OBJECT_PATH,
			MISSION_CONTROL_INTERFACE)
		mission_control_iface.GetConnectedAccounts(reply_handler=self.got_connected_accounts, error_handler=global_error_handler)
	
	def got_connected_accounts(self, accounts):
		for conn_name, conn_obj, profile, description, username in accounts:
			self.append(Account(conn_name, conn_obj, profile, description, username))
		self.emit('accounts-received')
