class CohobaFactory:
	def __init__(self):
		self.contactlist_handler_on = False
	
	def init_contactlist_handler(self):
		if not self.contactlist_handler_on:
			from cohoba.contacts.ContactListChannelHandler import ContactListChannelHandler
			ContactListChannelHandler()
			self.contactlist_handler_on = True
			
	def make_applet(self, applet, iid, mode=None):
		print 'CohobaFactory: Creating Applet:', applet, iid, mode
		
		# Presence Applet --------------
		from cohoba import COHOBA_APPLET_MODE_ME
		if iid == "OAFIID:CohobaMe" or mode == COHOBA_APPLET_MODE_ME:
			from cohoba.me.CohobaMeApplet import CohobaMeApplet
			CohobaMeApplet(applet)
			return True
		
		# Contact list applets --------------------
		from cohoba.applet.CohobaApplet import CohobaApplet
		from cohoba import COHOBA_APPLET_MODE_MAIN, COHOBA_APPLET_MODE_GROUP, COHOBA_APPLET_MODE_CONTACT
		if iid == "OAFIID:CohobaOverview":
			mode = COHOBA_APPLET_MODE_MAIN
		elif iid ==  "OAFIID:CohobaGroup":
			mode = COHOBA_APPLET_MODE_GROUP
		elif iid == "OAFIID:CohobaContact":
			mode = COHOBA_APPLET_MODE_CONTACT
		
		self.init_contactlist_handler()
		CohobaApplet(applet, mode)
		
		return True
