import py
from py.__.path.svn.urlcommand import InfoSvnCommand
from py.__.path.svn.testing.svntestbase import CommonCommandAndBindingTests, getrepowc

try:
    svnversion = py.path.local.sysfind('svn')
except py.error.ENOENT:
    py.test.skip("cannot test py.path.svn, 'svn' binary not found")

class TestSvnCommandPath(CommonCommandAndBindingTests):
    def setup_class(cls): 
        repo, wc = getrepowc()
        cls.root = py.path.svnurl(repo)

    def xtest_copy_file(self):
        raise py.test.Skipped(msg="XXX fix svnurl first")

    def xtest_copy_dir(self):
        py.test.skipp("XXX fix svnurl first")

    def XXXtest_info_log(self):
        url = self.root.join("samplefile")
        res = url.log(rev_start=1155, rev_end=1155, verbose=True)
        assert res[0].revision == 1155 and res[0].author == "jum"
        from time import gmtime
        t = gmtime(res[0].date)
        assert t.tm_year == 2003 and t.tm_mon == 7 and t.tm_mday == 17


class TestSvnInfoCommand:

    def test_svn_1_2(self):
        line = "   2256      hpk        165 Nov 24 17:55 __init__.py"
        info = InfoSvnCommand(line)
        assert info.last_author == 'hpk'
        assert info.created_rev == 2256
        assert info.kind == 'file'
        assert info.mtime == 1132851300.0
        assert info.size ==  165
        assert info.time == 1132851300000000.0

    def test_svn_1_3(self):
        line ="    4784 hpk                 2 Jun 01  2004 __init__.py"
        info = InfoSvnCommand(line)
        assert info.last_author == 'hpk'
        assert info.kind == 'file'
