import py

Module = py.test.collect.Module 
Directory = py.test.collect.Directory
Class = py.test.collect.Class
Generator = py.test.collect.Generator 
Function = py.test.Function 
Instance = py.test.collect.Instance 

additionalinfo = None

def adddefaultoptions(): 
    Option = py.test.Config.Option
    py.test.Config.addoptions('general options',
        Option('-v', '--verbose',
               action="count", dest="verbose", default=0,
               help="increase verbosity"),
        Option('-x', '--exitfirst',
               action="store_true", dest="exitfirst", default=False,
               help="exit instantly on first error or failed test."),
        Option('-s', '--nocapture',
               action="store_true", dest="nocapture", default=False,
               help="disable catching of sys.stdout/stderr output."),
        Option('-k', 
               action="store", dest="keyword", default='',
               help="only run test items matching the given (google-style) keyword expression"), 
        Option('-l', '--showlocals',
               action="store_true", dest="showlocals", default=False,
               help="show locals in tracebacks (disabled by default)"),
        Option('', '--pdb',
               action="store_true", dest="usepdb", default=False,
               help="start pdb (the Python debugger) on errors."),
        Option('', '--fulltrace',
               action="store_true", dest="fulltrace", default=False,
               help="don't cut any tracebacks (default is to cut)"),
        Option('', '--nomagic',
               action="store_true", dest="nomagic", default=False,
               help="refrain from using magic as much as possible"), 
        Option('', '--collectonly',
               action="store_true", dest="collectonly", default=False,
               help="only collect tests, don't execute them. "),
        Option('', '--traceconfig',
               action="store_true", dest="traceconfig", default=False,
               help="trace considerations of conftest.py files. "), 
    )
    py.test.Config.addoptions('test-session related options', 
        Option('', '--tkinter',
               action="store_true", dest="tkinter", default=False,
               help="use tkinter test session frontend."), 
        Option('', '--looponfailing',
               action="store_true", dest="looponfailing", default=False,
               help="loop on failing test set."), 
        Option('', '--session', 
               action="store", dest="session", default=None, 
               help="use given sessionclass, default is terminal."),
        Option('', '--exec',
               action="store", dest="executable", default=None,
               help="python executable to run the tests with. "),
    )
    
