//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah
// file name            : quickoutlinedlg.cpp
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
// C++ code generated with wxFormBuilder (version Jul 28 2007)
// http://www.wxformbuilder.org/
//
// PLEASE DO "NOT" EDIT THIS FILE!
///////////////////////////////////////////////////////////////////////////

#ifdef WX_PRECOMP

#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#else
#include <wx/wx.h>
#endif //WX_PRECOMP

#include "quickoutlinedlg.h"
#include "drawingutils.h"
#include "windowattrmanager.h"
#include "cl_editor.h"
#include "cpp_symbol_tree.h"
#include "macros.h"
#include "manager.h"

extern wxImageList* CreateSymbolTreeImages();

///////////////////////////////////////////////////////////////////////////
BEGIN_EVENT_TABLE(QuickOutlineDlg, wxDialog)
	EVT_CHAR_HOOK(QuickOutlineDlg::OnCharHook)
	EVT_TEXT(wxID_ANY, QuickOutlineDlg::OnTextEntered)
END_EVENT_TABLE()

QuickOutlineDlg::QuickOutlineDlg(wxWindow* parent, const wxString &fileName, int id, wxString title, wxPoint pos, wxSize size, int style )
		: wxDialog( parent, id, title, pos, size, style|wxRESIZE_BORDER)
		, m_fileName(fileName)
{
	this->SetSizeHints( wxDefaultSize, wxDefaultSize );
#ifdef __WXGTK__
	wxColour bgCol = DrawingUtils::GetPanelBgColour();
	wxColour fgCol = wxSystemSettings::GetColour( wxSYS_COLOUR_WINDOWTEXT );
#else
	wxColour bgCol = wxSystemSettings::GetColour( wxSYS_COLOUR_INFOBK   );
	wxColour fgCol = wxSystemSettings::GetColour( wxSYS_COLOUR_INFOTEXT );
#endif

	this->SetBackgroundColour( bgCol );

	wxBoxSizer* bSizer1;
	bSizer1 = new wxBoxSizer( wxVERTICAL );
	m_textFilter = new wxTextCtrl(this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0|wxNO_BORDER |wxTE_RICH2);

	m_textFilter->SetBackgroundColour( bgCol );
	m_textFilter->SetForegroundColour( fgCol );

	bSizer1->Add( m_textFilter, 0, wxALL|wxEXPAND, 5 );
	m_staticline1 = new wxStaticLine( this, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLI_HORIZONTAL );
	m_staticline1->SetBackgroundColour( bgCol );
	bSizer1->Add( m_staticline1, 0, wxEXPAND|wxLEFT|wxRIGHT, 5 );

	//build the outline view
	m_treeOutline = new CppSymbolTree( this, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTR_DEFAULT_STYLE|wxNO_BORDER);
	m_treeOutline->SetBackgroundColour( bgCol );
	m_treeOutline->SetForegroundColour( fgCol );
	m_treeOutline->SetSymbolsImages(CreateSymbolTreeImages());

	Connect(wxEVT_CMD_CPP_SYMBOL_ITEM_SELECTED, wxCommandEventHandler(QuickOutlineDlg::OnItemSelected), NULL, this);

	//no hidden root
	m_treeOutline->BuildTree(m_fileName);
	m_treeOutline->ExpandAll();

	bSizer1->Add( m_treeOutline, 1, wxALL|wxEXPAND, 5 );
	this->SetSizer( bSizer1 );
	this->Layout();
	Centre();
	m_textFilter->SetFocus();
	WindowAttrManager::Load(this, wxT("QuickOutlineDlg"), NULL);
}

QuickOutlineDlg::~QuickOutlineDlg()
{
	WindowAttrManager::Save(this, wxT("QuickOutlineDlg"), NULL);
}

void QuickOutlineDlg::OnCharHook(wxKeyEvent &e)
{
	if (e.GetKeyCode() == WXK_ESCAPE) {
		EndModal(wxID_CANCEL);

	} else if (e.GetKeyCode() == WXK_NUMPAD_ENTER || e.GetKeyCode() == WXK_RETURN) {
		m_treeOutline->ActivateSelectedItem();

	} else if (e.GetKeyCode() == WXK_UP) {
		m_treeOutline->AdvanceSelection(false);

	} else if (e.GetKeyCode() == WXK_DOWN) {
		m_treeOutline->AdvanceSelection();

	} else {
		e.Skip();
	}
}

void QuickOutlineDlg::OnTextEntered(wxCommandEvent &WXUNUSED(e))
{
	wxString curname = m_textFilter->GetValue();
	if (curname.IsEmpty() == false) {
		m_treeOutline->SelectItemByName(curname);
	}
}

void QuickOutlineDlg::OnItemSelected(wxCommandEvent& e)
{
	wxUnusedVar(e);
	Close();
}
