#ifndef __subversion_page__
#define __subversion_page__

/**
@file
Subclass of SubversionPageBase, which is generated by wxFormBuilder.
*/

#include "subversion2_ui.h"
#include "svninfo.h"
#include "svncommand.h"
#include "svntreedata.h"

class Subversion2;
class wxMenu;

class SvnPageSelectionInfo {

public:
	wxArrayString            m_paths;
	SvnTreeData::SvnNodeType m_selectionType;

public:
	SvnPageSelectionInfo() : m_selectionType(SvnTreeData::SvnNodeTypeInvalid) {}
	virtual ~SvnPageSelectionInfo() {}

	void Clear() {
		m_paths.Clear();
		m_selectionType = SvnTreeData::SvnNodeTypeInvalid;
	}
};

/** Implementing SubversionPageBase */
class SubversionView : public SubversionPageBase
{
	Subversion2*         m_plugin;
	wxTreeItemId         m_modifiedItems;
	SvnCommand           m_simpleCommand;
	SvnCommand           m_diffCommand;
	SvnPageSelectionInfo m_selectionInfo;

public:
	enum {
		SvnInfo_Tag,
		SvnInfo_Branch,
		SvnInfo_Info
	};

protected:
	void                     CreatGUIControls();
	void                     ClearAll();
	void                     DoAddNode(const wxString &title, int imgId, SvnTreeData::SvnNodeType nodeType, const wxArrayString &files);
	int                      DoGetIconIndex(const wxString &filename);
	SvnTreeData::SvnNodeType DoGetSelectionType(const wxArrayTreeItemIds &items);
	void                     DoGetPaths(const wxTreeItemId &parent, wxArrayString &paths);

protected:
	// Menu management
	void CreateFileMenu      (wxMenu *menu);
	void CreateRootMenu      (wxMenu *menu);
	void CreateSecondRootMenu(wxMenu *menu);

protected:
	// Handlers for SubversionPageBase events.
	void OnChangeRootDir ( wxCommandEvent& event );
	void OnTreeMenu      ( wxTreeEvent&    event );
	void OnItemActivated ( wxTreeEvent&    event );

	// IDE Events
	void OnWorkspaceLoaded(wxCommandEvent &event);
	void OnWorkspaceClosed(wxCommandEvent &event);
	void OnClearOuptut    (wxCommandEvent &event);
	void OnRefreshView    (wxCommandEvent &event);
	void OnFileRenamed    (wxCommandEvent &event);
	void OnFileAdded      (wxCommandEvent &event);
	void OnSettings       (wxCommandEvent &event);

	// Svn events
	void OnCommit           (wxCommandEvent &event);
	void OnUpdate           (wxCommandEvent &event);
	void OnRevert           (wxCommandEvent &event);
	void OnAdd              (wxCommandEvent &event);
	void OnDelete           (wxCommandEvent &event);
	void OnBranch           (wxCommandEvent &event);
	void OnTag              (wxCommandEvent &event);
	void OnResolve          (wxCommandEvent &event);
	void OnDiff             (wxCommandEvent &event);
	void OnPatch            (wxCommandEvent &event);
	void OnPatchDryRun      (wxCommandEvent &event);
	void OnStop             (wxCommandEvent &event);
	void OnCleanup          (wxCommandEvent &event);
	void OnShowSvnInfo      (wxCommandEvent &event);
	void OnCheckout         (wxCommandEvent &event);
	void OnIgnoreFile       (wxCommandEvent &event);
	void OnIgnoreFilePattern(wxCommandEvent &event);
	void OnBlame            (wxCommandEvent &event);

	DECLARE_EVENT_TABLE()

	void OnStopUI         (wxUpdateUIEvent &event);
	void OnClearOuptutUI  (wxUpdateUIEvent &event);

public:
	/** Constructor */
	SubversionView( wxWindow* parent, Subversion2 *plugin);
	virtual ~SubversionView();

	void     UpdateTree(const wxArrayString& modifiedFiles, const wxArrayString &conflictedFiles, const wxArrayString &unversionedFiles, const wxArrayString& newFiles, const wxArrayString& deletedFiles);
	void     BuildTree();
	void     BuildTree(const wxString &root);
	wxString GetRootDir() const {return m_textCtrlRootDir->GetValue();}
};

#endif // __subversion_page__
