// (c) 2004 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#include "slider.h"
#include <qapplication.h>
#include <qsize.h>


using Codeine::Slider;


Slider *Slider::s_instance = 0;


Slider::Slider( Qt::Orientation orientation, QWidget *parent, uint max )
      : QSlider( orientation, parent )
      , m_sliding( false )
      , m_outside( false )
      , m_prevValue( 0 )
{
   s_instance = this;

   setRange( 0, max );
   setFocusPolicy( NoFocus );
}


void
Slider::wheelEvent( QWheelEvent *e )
{
   //if you use this class elsewhere, NOTE this is Codeine specific
   e->ignore(); //pass to VideoWindow
}

void
Slider::mouseMoveEvent( QMouseEvent *e )
{
   if( m_sliding )
   {
      //feels better, but using set value of 20 is bad of course
      QRect rect = this->rect();
      rect.addCoords( -20, -20, 20, 20 );

      if( orientation() == Horizontal && !rect.contains( e->pos() ) ) {
         if( !m_outside )
            QSlider::setValue( m_prevValue );
         m_outside = true;
      } else {
         m_outside = false;

         QSlider::setValue( orientation() == Horizontal
            ? QRangeControl::valueFromPosition( e->pos().x() - sliderRect().width()/2,  width()  - sliderRect().width() )
            : QRangeControl::valueFromPosition( e->pos().y() - sliderRect().height()/2, height() - sliderRect().height() ) );

         emit sliderMoved( value() );
      }
   }
   else
      QSlider::mouseMoveEvent( e );
}

void
Slider::mousePressEvent( QMouseEvent *e )
{
   m_sliding   = true;
   m_prevValue = QSlider::value();

   if( !sliderRect().contains( e->pos() ) )
      mouseMoveEvent( e );
}

void
Slider::mouseReleaseEvent( QMouseEvent* )
{
   if( !m_outside && QSlider::value() != m_prevValue )
      emit sliderReleased( value() );

   m_sliding = false;
   m_outside = false;
}

void
Slider::setValue( int newValue )
{
   //don't adjust the slider while the user is dragging it!

   if( !m_sliding || m_outside )
      QSlider::setValue( adjustValue( newValue ) );
   else
      m_prevValue = newValue;
}
