/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_EFFECT_CONTEXT_H_
#define _CTK_EFFECT_CONTEXT_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/ctk-render-target.h>

G_BEGIN_DECLS

#define CTK_TYPE_EFFECT_CONTEXT (ctk_effect_context_get_type ())

#define CTK_EFFECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_EFFECT_CONTEXT, CtkEffectContext))

#define CTK_EFFECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_EFFECT_CONTEXT, CtkEffectContextClass))

#define CTK_IS_EFFECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_EFFECT_CONTEXT))

#define CTK_IS_EFFECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_EFFECT_CONTEXT))

#define CTK_EFFECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_EFFECT_CONTEXT, CtkEffectContextClass))

typedef struct _CtkEffectContext        CtkEffectContext;
typedef struct _CtkEffectContextClass   CtkEffectContextClass;
typedef struct _CtkEffectContextPrivate CtkEffectContextPrivate;
 
struct _CtkEffectContext
{
  GObject                  parent;	

  CtkEffectContextPrivate *priv;
};

struct _CtkEffectContextClass
{
  /*< private >*/
  GObjectClass   parent_class;

  void (*_view_padding1) (void);
  void (*_view_padding2) (void);
  void (*_view_padding3) (void);
  void (*_view_padding4) (void);
  void (*_view_padding5) (void);
  void (*_view_padding6) (void);
};

GType              ctk_effect_context_get_type              (void) G_GNUC_CONST;

CtkEffectContext * ctk_effect_context_get_default_for_stage (ClutterStage *stage);

CtkEffectContext * ctk_effect_context_get_default_for_actor (ClutterActor *actor);

CtkRenderTarget  * ctk_effect_context_grab_render_target_for_size(CtkEffectContext *self,
                                                          guint             width,
                                                          guint             height);

CtkRenderTarget * ctk_effect_context_grab_render_target_for_actor (CtkEffectContext *self,
                                                                   ClutterActor     *actor);

CtkRenderTarget * ctk_effect_context_grab_render_target (CtkEffectContext *self);
                                                                   
void              ctk_effect_context_release_render_target (CtkEffectContext *self,
                                                            CtkRenderTarget  *target);

void              ctk_effect_context_push_render_target (CtkEffectContext *self,
                                                         CtkRenderTarget  *target);

CtkRenderTarget * ctk_effect_context_pop_render_target  (CtkEffectContext *self);

CtkRenderTarget * ctk_effect_context_peek_render_target (CtkEffectContext *self);

CtkRenderTarget * ctk_effect_context_get_utility_render_target (CtkEffectContext *self);

G_END_DECLS

#endif /* _CTK_EFFECT_CONTEXT_H_ */

