dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2003 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ(2.57)

AC_DEFUN([CL_PERROR],
[AC_MSG_CHECKING(for perror declaration)
AC_CACHE_VAL(cl_cv_proto_perror, [
AC_TRY_COMPILE([
/* Some systems declare perror() in <errno.h>, some in <stdio.h>, some don't
   declare it at all. */
#include <stdio.h>
#include <errno.h>
]AC_LANG_EXTERN[double perror ();], [],
cl_cv_proto_perror=no, cl_cv_proto_perror=yes)
])
AC_MSG_RESULT([$cl_cv_proto_perror])
if test $cl_cv_proto_perror = yes; then
AC_DEFINE(HAVE_PERROR_DECL,,[<errno.h> or <stdio.h> contains a declaration for perror()])
fi
])
