# -*- coding: ascii -*-

###########################################################################
# clive, video extraction utility
# Copyright (C) 2007-2008 Toni Gundogdu
#
# clive is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 0.1.2-1307 USA
###########################################################################

## The classes that wrap the recall functionalities

import os

from clive.path import ConfigDir

__all__ = ['Recall']

## The class that wraps the recall functionalities
class Recall:

    ## Writes URL batch to the recall file
    def write(self, batch):
        f = open(ConfigDir().recallfile(), 'w')
        for url in batch: f.write('%s\n' % url)
        f.close()

    ## Clears data
    def clear(self, say):
        if os.path.exists(ConfigDir().recallfile()):
            a = raw_input('> clear last batch, are you sure? (y/N): ')
            if len(a) and a.lower()[0] == 'y':
                os.remove(ConfigDir().recallfile())
        else:
            say('error: recall: nothing to clear')
