#!/usr/bin/env python
###########################################################################
# clive, video extraction utility
# Copyright (C) 2007 Toni Gundogdu
#
# clive is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 0.1.2-1307 USA
###########################################################################
"""
easyinstall (setuptools)
===========================================================================
tested: 0.6c3 (xubuntu), status: unused

  - packages (rpm,deb,tgz) req. easyinstall to be installed
  - unreliable install_requires

  NOTE: can be used to create python eggs, e.g.:
          # python setup.py bdist_egg
"""
# easyinstall (setuptools):
#import ez_setup
#ez_setup.use_setuptools()
#from setuptools import setup

from distutils.core import setup
from clive.version import *
import glob
import sys

if sys.platform == 'win32':
  # py2exe:
  try:
    import py2exe
    _is_py2exe = 1
  except:
    _is_py2exe = 0


data_files = [
  ('man/man1', ['man/clive.1.gz'])
]

classifiers = [
  'Environment :: Console',
  'Intended Audience :: End Users/Desktop',
  'Operating System :: POSIX',
  'Programming Language :: Python',
  'License :: OSI Approved :: GNU General Public License (GPL)',
  'Natural Language :: English',
  'Topic :: Internet',
  'Topic :: Utilities'
]

setup_args = dict(
  name              = PACKAGE_NAME,
  version           = PACKAGE_VERSION,
  description       = PACKAGE_DESC,
  long_description  = PACKAGE_DESC,
  maintainer        = 'Toni Gundogdu',
  maintainer_email  = 'legatvs@gmail.com',
  url               = 'http://home.gna.org/clive',
  license           = 'GPL',
  scripts           = [PACKAGE_SCRIPT],
  packages          = ['clive'],
  data_files        = data_files,
  classifiers       = classifiers,
  platforms         = ['Any'],
  # setuptools (easyinstall):
  #entry_points      = {'console_scripts':['clive = clive.cli:main']},
  #install_requires = ['pkg1>=x.x','pkg2']
)

if sys.platform == 'win32' and _is_py2exe:
  # py2exe:
  setup_args['console'] = [PACKAGE_SCRIPT]

setup(**setup_args)
