# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-

"""Tests for PageUpdate"""

import os

from autopilot.matchers import Eventually
from testtools.matchers import Equals

from click_update_manager import UbuntuTouchAppTestCase


class PageUpdateTests(UbuntuTouchAppTestCase):
    """Page Update Tests."""

    test_qml_file = "/usr/share/click-update-manager/updatemanager.qml"

    def test_UI_is_loaded(self):
        """Must be able to see the mainview."""

        mainView = self.get_mainview()
        self.assertThat(mainView.visible, Eventually(Equals(True)))

    def test_loading_disappear(self):
        """Check the loading indicator disappears"""

        loading = self.get_object(objectName="loadingIndicator")
        self.assertThat(loading.visible, Eventually(Equals(False)))

    def test_check_again(self):
        """Check the loading indicator disappears"""

        loading = self.get_object(objectName="loadingIndicator")
        self.assertThat(loading.visible, Eventually(Equals(False)))
        self.mouse_click(objectName="retryButton")
        self.assertThat(loading.visible, Eventually(Equals(True)))
        self.assertThat(loading.visible, Eventually(Equals(False)))
