# test CLC-INTERCAL compiler

# Copyright (c) 2007 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

my @all_tests = (
    ['Comment', '', "*000 COMMENT\n", 0, "COMMENT"],
    ['READ OUT', '', "XII\n", undef, "DO .1 <- #12\nPLEASE READ OUT .1"],
    ['NOT', '', "XII\n", undef, "DO .1 <- #12\nDO NOT .1 <- #24\nPLEASE READ OUT .1"],
    ['DOUBLE_OH_SEVEN 1', '', "XII\n", undef, "DO .1 <- #12\nDO %0 .1 <- #24\nPLEASE READ OUT .1"],
    ['DOUBLE_OH_SEVEN 2', '', "XXIV\n", undef, "DO .1 <- #12\nDO %100 .1 <- #24\nPLEASE READ OUT .1"],
    ['DOUBLE_OH_SEVEN 3', '', "XXIV\n", undef, "DO .1 <- #100\nDO %.1 .1 <- #24\nPLEASE READ OUT .1"],
    ['DOUBLE_OH_SEVEN 4', '', "NIHIL\n", undef, "DO .1 <- #0\nDO %.1 .1 <- #24\nPLEASE READ OUT .1"],
    ['NOT DOUBLE_OH_SEVEN 1', '', "XII\n", undef, "DO .1 <- #12\nDO NOT %0 .1 <- #24\nPLEASE READ OUT .1"],
    ['NOT DOUBLE_OH_SEVEN 2', '', "XII\n", undef, "DO .1 <- #12\nDO NOT %100 .1 <- #24\nPLEASE READ OUT .1"],
    ['NOT DOUBLE_OH_SEVEN 3', '', "C\n", undef, "DO .1 <- #100\nDO NOT %.1 .1 <- #24\nPLEASE READ OUT .1"],
    ['NOT DOUBLE_OH_SEVEN 4', '', "NIHIL\n", undef, "DO .1 <- #0\nDO NOT %.1 .1 <- #24\nPLEASE READ OUT .1"],
    ['DOUBLE_OH_SEVEN 1 NOT', '', "XII\n", undef, "DO .1 <- #12\nDO %0 NOT .1 <- #24\nPLEASE READ OUT .1"],
    ['DOUBLE_OH_SEVEN 2 NOT', '', "XII\n", undef, "DO .1 <- #12\nDO %100 NOT .1 <- #24\nPLEASE READ OUT .1"],
    ['DOUBLE_OH_SEVEN 3 NOT', '', "C\n", undef, "DO .1 <- #100\nDO %.1 NOT .1 <- #24\nPLEASE READ OUT .1"],
    ['DOUBLE_OH_SEVEN 4 NOT', '', "NIHIL\n", undef, "DO .1 <- #0\nDO %.1 NOT .1 <- #24\nPLEASE READ OUT .1"],
    # XXX more tests would be nice
);

require 't/compiler-test';

runtest('sick', 'DO GIVE UP', \@all_tests);

