#!/usr/bin/perl -w

eval 'exec perl -S $0 ${1+"$@"}'
    if 0;

# This script will create the Makefile to build and install CLC-INTERCAL

# This file is part of CLC-INTERCAL 1.-94.-3

# Copyright (c) 2007 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

require 5.005;
use Config qw(%Config);
use ExtUtils::MakeMaker;
use strict;

use vars qw($PERVERSION $VERSION);
$PERVERSION = "CLC-INTERCAL Makefile.PL 1.-94.-3";
($VERSION) = $PERVERSION =~ /(\S+)$/;

my @want_type = grep { /^type=/ } @ARGV;
@ARGV = grep { ! /^type=/ } @ARGV;

open(MANIFEST, "MANIFEST")
    or die "Sorry, I can't function without file \"MANIFEST\"\n";

my $pm_dir = 'INTERCAL';
my $iacc_dir = 'Include';
my $iacc_suffix = 'iacc';
my $sick_suffix = 'i';
my $iasm_suffix = 'iasm';
my $bin_dir = 'bin';

my @iacc = ();
my @sick = ();
my @iasm = ();
my @bin = ();
while (<MANIFEST>) {
    chomp;
    s/\s+\S+$//;
    my $on = $_;
    if (s#^$pm_dir/*##o) {
	if (s#^$iacc_dir/*##o) {
	    push @iacc, $1 if /^(.*)\.$iacc_suffix$/o;
	    push @sick, $1 if /^(.*)\.$sick_suffix$/o;
	    push @iasm, $1 if /^(.*)\.$iasm_suffix$/o;
	}
    } elsif (m#^$bin_dir/#o) {
	s/\s+\S+$//;
	push @bin, $_;
    }
}
close MANIFEST;

WriteMakefile(NAME => 'Language::INTERCAL',
	      DISTNAME => 'CLC-INTERCAL',
	      EXE_FILES => \@bin,,
	      VERSION => $VERSION,
	      PERL_MALLOC_OK => 1,
	      PM_FILTER => '$(PERL) Generate/Generate',
#	      PMLIBDIRS => [ 'Language' ],
	      PREREQ_PM => {
		  'Carp' => 0,
		  'Cwd' => 0,
		  'File::Basename' => 0,
		  'File::Spec' => 0,
		  'Getopt::Long' => 0,
		  'IO::File' => 0,
		  'IO::Handle' => 0,
	      },
	      dist => {
		  COMPRESS => 'gzip',
		  SUFFIX => '.gz',
		  DIST_DEFAULT => 'ddsh_dist',
	      },
	      clean => { FILES => 'iacc_to_io sick_to_io' },
);

sub MY::constants {
    package MY;
    my $i = shift->SUPER::constants(@_);
    $i .= "\n# Needed to run iacc\n";
    $i .= "INST_IACC = \$(INST_LIB)/Language/INTERCAL/Include\n";
    $i .= "SICK_OPTIONS = --nouserrc --batch --bug=0 --ubug=0 --stdtrace=/dev/null --notrace\n";
#    $i .= "SICK_OPTIONS += -v\n";
    $i .= "SICK = \$(FULLPERL) -I\$(INST_ARCHLIB) -I\$(INST_LIB) \\\n";
    $i .= "\t-I\$(PERL_ARCHLIB) -I\$(PERL_LIB) \$(INST_SCRIPT)/sick \\\n";
    $i .= "\t\$(SICK_OPTIONS)\n";
    $i;
}

sub MY::postamble {
    package MY;
    my $i = shift->SUPER::postamble(@_);
    $i .= <<EOI for @iacc;
pure_all :: \$(INST_IACC)/$_.io
	\$(NOECHO) \$(NOOP)

\$(INST_IACC)/$_.io : \$(INST_IACC)/$_.$iacc_suffix
	\$(SICK) -lObject -piacc --output \$(INST_IACC)/$_.io \$(INST_IACC)/$_.$iacc_suffix
EOI

    $i .= <<EOI for @sick;
pure_all :: \$(INST_IACC)/$_.io
	\$(NOECHO) \$(NOOP)

\$(INST_IACC)/$_.io : \$(INST_IACC)/sick.io \\
		\$(INST_IACC)/postpre.io \\
		\$(INST_IACC)/$_.$sick_suffix
	\$(SICK) -lObject -psick --output \$(INST_IACC)/$_.io \$(INST_IACC)/$_.$sick_suffix
EOI

    $i .= <<EOI for @iasm;
pure_all :: \$(INST_IACC)/$_.io
	\$(NOECHO) \$(NOOP)

\$(INST_IACC)/$_.io : \$(INST_IACC)/asm.io \\
		\$(INST_IACC)/postpre.io \\
		\$(INST_IACC)/$_.$iasm_suffix
	\$(SICK) -lObject -pasm --output \$(INST_IACC)/$_.io \$(INST_IACC)/$_.$iasm_suffix
EOI

    $i;
};

sub MY::dist_core {
    package MY;
    my $i = shift->SUPER::dist_core(@_);
    $i .= <<'EOF';

ddsh_dist :
	$(RM_F) $(DISTVNAME).ddsh $(DISTVNAME).ddsh$(SUFFIX)
	$(PERL) ./makeddshdist MANIFEST $(DISTVNAME).ddsh $(VERSION)
	$(COMPRESS) $(DISTVNAME).ddsh

EOF
    $i;
}

