;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: cl-user -*-
;;; $Id: odcl.asd,v 1.3 2003/05/29 18:03:17 adam Exp $
;;;
;;; Copyright (c) 2000 - 2002 onShore Development, Inc.

(defpackage :odcl-system (:use #:asdf #:cl))
(in-package :odcl-system)

#+sbcl (setf asdf::*compile-file-warnings-behaviour* :ignore)

(defsystem :odcl
    :version "1.3.3"
    :author "onShore Development <webco-devel@lists.onshored.com>"
    :serial t
    :components
    ((:file "package")
     #+sbcl (:file "sbcl")
     (:file "macros")
     (:file "conditions")
     (:file "interfaces")
     (:file "locale")
     (:file "alist")
     (:file "diagnostics")
     (:file "plist")
     (:file "currency")
     (:file "assert")
     (:file "network")
     (:file "numbers")
     #+cmu (:file "libc")
     (:file "string")
     (:file "hash")
     (:file "list")
     (:file "symbol")
     (:file "event")
     (:file "transaction")
     (:file "objects")
     (:file "index")
     (:file "priority-queue")
     (:file "property-sheets")
     (:file "search-forms")
     (:file "tree")
     (:file "simple-cache")
     (:file "lru-cache")
     (:file "interactive")
     (:file "parsing")
     (:file "mailer")
     (:file "regression")
     (:file "uri")
     (:file "filesystem")
     (:file "persistence")
     (:file "time")
     (:file "iso-8601")
     #+cmu (:file "profile")
     #+cmu (:file "log")
     (:module "tests"
              :components ((:file "test-avl")
                           (:file "test-filesystem")
                           (:file "test-cache")
                           (:file "test-lru-cache")
                           (:file "test-log")
                           (:file "test-parsing")
                           (:file "test-transaction")
                           (:file "test-queue")
                           (:file "test-string")
                           (:file "test-time")
                           (:file "test-messages")
                           (:file "test-uri")))))


