(defclass test ()
  ((slot :accessor slot :initarg :slot)))

(defvar *object/value*
  (make-instance 'test :slot 42))

(defvar *object/symbol*
  (make-instance 'test
    :slot (let ((sym (make-symbol "BLA")))
            (setf (symbol-value sym) 42)
            sym)))

(defun rung ()
  (time (loop repeat 100000
              sum  (let ((save (slot *object/value*)))
                     (unwind-protect
                       (progn
                         (setf (slot *object/value*) (random 200))
                         (slot *object/value*))
                       (setf (slot *object/value*) save))))))

(defun runl ()
  (time (loop repeat 100000
              sum (progv (list (slot *object/symbol*))
                         (list (random 200))
                    (symbol-value
                     (slot *object/symbol*))))))

