#!/bin/sh
#
# Script to generate $C_FILE
#

ECHO=/usr/bin/printf

#MINUS_e=X`$ECHO -n -e`
#if [ $MINUS_e != "X" ] ; then
#	MINUS_e=""
#else
#	MINUS_e="-e"
#fi

#MINUS_E=X`$ECHO -n -E`
#if [ $MINUS_E != "X" ] ; then
#	MINUS_E=""
#else
#	MINUS_E="-E"
#fi


CUR_DIR=`pwd`
C_FILE="$CUR_DIR/modules_init.c"
H_FILE="$CUR_DIR/modules_init.h"
MOD_FILE="$CUR_DIR/Make_modules"
SRC_FILE="$CUR_DIR/Make_sources"
U_FILE="$CUR_DIR/modules_upgrade.c"

/usr/bin/printf "Scanning extension modules for entry points.\n"


#start of the files which inturn removes any existing file
#

# start the Makefile included file for $SERV_MODULES
cat <<EOF  >$MOD_FILE
#
# Make_modules
# This file is to be included by Makefile to dynamically add modules to the build process
# THIS FILE WAS AUTO GENERATED BY mk_modules_init.sh DO NOT EDIT THIS FILE
#

EOF

# start the Makefile included file for $SOURCES
cat <<EOF  >$SRC_FILE
#
# Make_sources
# This file is to be included by Makefile to dynamically add modules to the build process
# THIS FILE WAS AUTO GENERATED BY mk_modules_init.sh DO NOT EDIT THIS FILE
#

EOF

# start the upgrade file
cat <<EOF  >$U_FILE
/*
 * $U_FILE
 * Auto generated by mk_modules_init.sh DO NOT EDIT THIS FILE
 */



#include "sysdep.h"
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <libcitadel.h>
#include "citadel.h"
#include "modules_init.h"
#include "sysdep_decls.h"




void upgrade_modules (void)
{

    CtdlLogPrintf (CTDL_INFO, "Upgrade modules.\n");

EOF

# start the c file
cat <<EOF  >$C_FILE
/*
 * $C_FILE
 * Auto generated by mk_modules_init.sh DO NOT EDIT THIS FILE
 */



#include "sysdep.h"
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <libcitadel.h>
#include "citadel.h"
#include "modules_init.h"
#include "sysdep_decls.h"


void LogPrintMessages(long err);
extern long DetailErrorFlags;



void initialise_modules (int threading)
{
    long filter;
    nSizErrmsg = 0;

    if (threading)
        CtdlLogPrintf (CTDL_INFO, "Initialise modules, CtdlThreads enabled.\n");
    else
        CtdlLogPrintf (CTDL_INFO, "Initialise modules, CtdlThreads not yet enabled.\n");
/* static server initialization: */
        CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL(citserver));
        CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL(control));
        CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL(euidindex));
        CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL(file_ops));
        CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL(msgbase));
        CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL(room_ops));
        CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL(user_ops));
/* dynamic modules: */

EOF


#start the header file
cat <<EOF > $H_FILE
/* 
 * $H_FILE
 * Auto generated by mk_modules_init.sh DO NOT EDIT THIS FILE
 */


#ifndef MODULES_INIT_H
#define MODULES_INIT_H
#include "ctdl_module.h"
extern size_t nSizErrmsg;
void initialise_modules (int threading);
void upgrade_modules(void);

	CTDL_MODULE_INIT(citserver);
	CTDL_MODULE_INIT(control);
	CTDL_MODULE_INIT(euidindex);
	CTDL_MODULE_INIT(file_ops);
	CTDL_MODULE_INIT(msgbase);
	CTDL_MODULE_INIT(room_ops);
	CTDL_MODULE_INIT(user_ops);
EOF

for i in serv_*.c
do
	RES=X`grep CTDL_MODULE_INIT $i | cut -f2 -d\( | cut -f1 -d\)`
	if [ $RES != "X" ] ; then
		RES_OUT=`echo $RES | cut -b2-`
		/usr/bin/printf "Found entry point in file $i\n"
cat <<EOF  >> $C_FILE
	CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL($RES_OUT));

EOF
cat <<EOF >>$H_FILE
CTDL_MODULE_INIT($RES_OUT);
EOF
	fi
	RES=X`grep CTDL_MODULE_UPGRADE $i | cut -f2 -d\( | cut -f1 -d\)`
	if [ $RES != "X" ] ; then
		RES_OUT=`echo $RES | cut -b2-`
		/usr/bin/printf "Found upgrade point in file $i\n"
cat <<EOF  >> $U_FILE
	CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_UPGRADE_CALL($RES_OUT));

EOF
cat <<EOF >>$H_FILE
CTDL_MODULE_UPGRADE($RES_OUT);
EOF
	fi
done


if [ -d "modules" ] ; then
	cd modules
	for j in *
	do
		if [ -d $j ] ; then
			cd $j
			for k in *.c
			do
				if [ -f "$k" ] ; then
# Add this .c file to the Makefile included list of SOURCES
cat <<EOF >> $SRC_FILE
SOURCES += modules/$j/$k
EOF

# Generate a .o file name
O_FILE=`basename $k .c`
O_FILE="$O_FILE.o"
# Add this .o file to the Makefile included list of SERV_MODULES
cat <<EOF >> $MOD_FILE
SERV_MODULES += modules/$j/$O_FILE
EOF
	
					RES=X`grep CTDL_MODULE_INIT $k | cut -f2 -d\( | cut -f1 -d\)`
					if [ $RES != "X" ] ; then
						RES_OUT=`echo $RES | cut -b2-`
						/usr/bin/printf "Found entry point in file modules/$j/$k\n"
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
	CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL($RES_OUT));
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
	CTDL_MODULE_INIT($RES_OUT);
EOF
					fi
					RES=X`grep CTDL_MODULE_UPGRADE $k | cut -f2 -d\( | cut -f1 -d\)`
					if [ $RES != "X" ] ; then
						RES_OUT=`echo $RES | cut -b2-`
						/usr/bin/printf "Found upgrade point in file modules/$j/$k\n"
# Add this entry point to the .c file
cat <<EOF >> $U_FILE
	CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_UPGRADE_CALL($RES_OUT));
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
	CTDL_MODULE_UPGRADE($RES_OUT);
EOF
					fi
				fi
			done
			cd ..
		fi
	done
fi

cd $CUR_DIR

if [ -d "user_modules" ] ; then
	cd user_modules
	for j in *
	do
		if [ -d $j ] ; then
			cd $j
			for k in *.c
			do
				if [ -f "$k" ] ; then
# Add this .c file to the Makefile included list of SOURCES
cat <<EOF >> $SRC_FILE
SOURCES += user_modules/$j/$k
EOF

# Generate a .o file name
O_FILE=`basename $k .c`
O_FILE="$O_FILE.o"
# Add this .o file to the Makefile included list of SERV_MODULES
cat <<EOF >> $MOD_FILE
SERV_MODULES += user_modules/$j/$O_FILE
EOF
	
					RES=X`grep CTDL_MODULE_INIT $k | cut -f2 -d\( | cut -f1 -d\)`
					if [ $RES != "X" ] ; then
						RES_OUT=`echo $RES | cut -b2-`
						/usr/bin/printf "Found entry point in file user_modules/$j/$k\n"
cat <<EOF >> $C_FILE
	CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_INIT_CALL($RES_OUT));
EOF
cat <<EOF >> $H_FILE
CTDL_MODULE_INIT($RES_OUT);
EOF
					fi
					RES=X`grep CTDL_MODULE_UPGRADE $k | cut -f2 -d\( | cut -f1 -d\)`
					if [ $RES != "X" ] ; then
						RES_OUT=`echo $RES | cut -b2-`
						/usr/bin/printf "Found upgrade point in file user_modules/$j/$k\n"
cat <<EOF >> $U_FILE
	CtdlLogPrintf (CTDL_INFO, "%s\n", CTDL_UPGRADE_CALL($RES_OUT));
EOF
cat <<EOF >> $H_FILE
CTDL_MODULE_UPGRADE($RES_OUT);
EOF
					fi
				fi
			done
			cd ..
		fi
	done
fi

cd $CUR_DIR

/usr/bin/printf "\n\n" >> $C_FILE
/usr/bin/printf "\tfor (filter = 1; filter != 0; filter = filter << 1)\n" >> $C_FILE
/usr/bin/printf "\t\tif ((filter & DetailErrorFlags) != 0)\n" >> $C_FILE
/usr/bin/printf "\t\t\tLogPrintMessages(filter);\n" >> $C_FILE
/usr/bin/printf "}\n" >> $C_FILE

#close the upgrade file
/usr/bin/printf "}\n" >> $U_FILE

/usr/bin/printf "\n#endif /* MODULES_INIT_H */\n" >> $H_FILE
