use strict;
use warnings;
use Module::Build::CipUX;

my $builder = Module::Build::CipUX->new(
    module_name       => 'CipUX::Storage',
    license           => 'gpl',
    dist_author       => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version_from => 'lib/CipUX/Storage.pm',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'Test::Perl::Critic'  => 0,
        'Test::Pod::Coverage' => '1.04',
    },

    build_requires => {
        'Module::Build'        => 0,
        'Module::Build::CipUX' => '0.3.0',
        'Test::More'           => 0,
        'Test::Pod'            => '1.14',
    },
    requires => {
        'Carp'          => 0,
        'Class::Std'    => '0.0.9',
        'CipUX'         => '3.4.0.0',
        'Data::Dumper'  => 0,
        'Getopt::Long'  => 0,
        'Log::Log4perl' => 0,
        'Net::LDAP'     => 0,
        'Pod::Usage'    => 0,
        'Readonly'      => 0,
        'version'       => 0,
    },

    add_to_cleanup => ['CipUX-Storage-*'],
);

$builder->create_build_script();
