use strict;
use warnings;
use Module::Build::CipUX;

use version; our $VERSION = qv('3.4.0.6');

my $builder = Module::Build::CipUX->new(
    module_name  => 'CipUX::RPC::Client',
    license      => 'gpl2',
    dist_author  => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version => $VERSION,

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    #    verbose            => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'File::Spec'          => 0,
        'Test::More'          => 0,
        'Test::Perl::Critic'  => 0,
        'Test::Pod'           => '1.14',
        'Test::Pod::Coverage' => '1.04',
    },

    build_requires => { 'Module::Build::CipUX' => '0.4.0', },

    requires => {
        'Carp'             => 0,
        'CipUX'            => '3.4.0.0',
        'Class::Std'       => '0.0.9',
        'Data::Dumper'     => 0,
        'English'          => 0,
        'Frontier::Client' => 0,
        'Log::Log4perl'    => 0,
        'Readonly'         => 0,
        'version'          => 0,
    },

    add_to_cleanup => ['CipUX-RPC-Client-*'],
);

# BUILD target
#$builder->do_create_readme();
#$builder->do_create_makefile_pl();
$builder->create_build_script();
