# +=========================================================================+
# || /etc/cipux/cipux-object.conf                                          ||
# ||                                                                       ||
# || Example configuration file for the CipUX object layer. It should      ||
# || provide the important information about creating CipUX objects.       ||
# || See manual page for more information.                                 ||
# ||                                                                       ||
# || Copyright (C) 2007 - 2009 by Christian Kuelker                        ||
# ||                                                                       ||
# || License: GNU GPL version 2 or any later version.                      ||
# ||                                                                       ||
# +=========================================================================+

# do NOT change the ordering of the configuration sections

# +=========================================================================+
# || Local replacement variables                                           ||
# +=========================================================================+
# TODO: get that from cipux.ini
my $cipux_home_directory = "/home/cipux0";
my $usr_sft_quota        = 100000;
my $usr_hrd_quota        = 200000;
my $grp_sft_quota        = 300000;
my $grp_hrd_quota        = 400000;

# +=========================================================================+
# || CipUX Object Relation Section                                         ||
# +=========================================================================+
# $cfg_coupling_hr
$cfg = {
    coupling => {

        ### cipux_ldap ###
        'cipux_ldap_root_node_object' => {
            order       => ['cipux_ldap_root_node'],
            object_attr => ['ou'],
            coupling    => {},
            overwrite   => {},
        },

        ### ldap_orga_node ###
        'cipux_ldap_orga_node_object' => {
            order       => ['cipux_ldap_orga_node'],
            object_attr => ['ou'],
            coupling    => {},
            overwrite   => {
                cipux_ldap_orga_node =>
                    { 'cipuxRemark' => 'CipUX object layer', },
            },
        },

        ### account ###
        'cipux_account_object' => {
            order    => [qw(cipux_account.group cipux_account.user)],
            coupling => {
                'cipux_account.group' => {
                    cn        => 'uid',
                    gidNumber => 'uidNumber',
                },
                'cipux_account.user' => {
                    uid       => 'cn',
                    uidNumber => 'gidNumber',
                },
            },
            object_attr => [qw(cn uid)],
            overwrite   => {
                'cipux_account.group' => {
                    'cipuxRemark'    => 'CipUX object layer',
                    'cipuxRole'      => 'none',
                    'cipuxSoftQuota' => $grp_sft_quota,
                    'cipuxHardQuota' => $grp_hrd_quota,
                },
                'cipux_account.user' => {
                    'cipuxRemark'    => 'CipUX object layer',
                    'cipuxRole'      => 'account',
                    'cipuxSoftQuota' => $usr_sft_quota,
                    'cipuxHardQuota' => $usr_hrd_quota,
                },
            },
        },

        ### share ###
        'cipux_share_object' => {
            order    => [qw(cipux_share.group cipux_share.user)],
            coupling => {
                'cipux_share.group' => {
                    cn        => 'uid',
                    gidNumber => 'uidNumber',
                },
                'cipux_share.user' => {
                    uid       => 'cn',
                    uidNumber => 'gidNumber',
                },
            },
            object_attr => [qw(cn uid)],
            overwrite   => {
                'cipux_share.group' => {
                    'cipuxIsShare' => 'TRUE',
                    cipuxRemark    => 'CipUX object layer',
                },
                'cipux_share.user' => {
                    'cipuxIsShare' => 'TRUE',
                    cipuxRemark    => 'CipUX object layer',
                },
            },
        },

        ### role ###
        'DELcipux_role_object' => {
            order       => [qw(cipux_role.group)],
            coupling    => {},
            object_attr => [qw(cn)],
            overwrite   => { 'cipux_role.group' => {}, },
        },
        'cipux_role_object' => {
            order    => [qw(cipux_role.group cipux_account.user)],
            coupling => {
                'cipux_role.group' => {
                    cn        => 'uid',
                    gidNumber => 'uidNumber',
                },
                'cipux_account.user' => {
                    uid       => 'cn',
                    uidNumber => 'gidNumber',
                },
            },
            object_attr => [qw(cn uid)],
            overwrite   => {
                'cipux_role.group' => {
                    'cipuxRemark'  => 'CipUX object layer',
                    'cipuxRole'    => 'role',
                    'cipuxIsRole'  => 'TRUE',
                    'cipuxIsSkel'  => 'TRUE',
                    'cipuxIsShare' => 'FALSE',
                },
                'cipux_account.user' => {
                    'cipuxFirstname' => 'role',
                    'cipuxLastname'  => 'role',
                    'cipuxRemark'    => 'CipUX object layer',
                    'cipuxRole'      => 'role',
                    'cipuxIsRole'    => 'TRUE',
                    'cipuxIsSkel'    => 'TRUE',
                    'cipuxIsShare'   => 'FALSE',
                    'cipuxFirstname' => 'Generic',
                    'cipuxLastname'  => 'Role',
                },
            },
        },

        # authority role
        'authority_role_object' => {
            order       => [qw(authority_account.group)],
            coupling    => {},
            object_attr => [qw(cn)],
            overwrite   => { 'authority_account.group' => {}, },
        },

        ### skel ###
        'cipux_skel_object' => {
            order    => [qw(cipux_account.group cipux_account.user)],
            coupling => {
                'cipux_account.group' => {
                    cn        => 'uid',
                    gidNumber => 'uidNumber',
                },
                'cipux_account.user' => {
                    uid       => 'cn',
                    uidNumber => 'gidNumber',
                },
            },
            object_attr => [qw(cn uid)],
            overwrite   => {
                'cipux_account.group' => {
                    'cipuxRemark'  => 'CipUX object layer',
                    'cipuxRole'    => 'role',
                    'cipuxIsRole'  => 'TRUE',
                    'cipuxIsSkel'  => 'TRUE',
                    'cipuxIsShare' => 'FALSE',
                },
                'cipux_account.user' => {
                    'cipuxRemark'    => 'CipUX object layer',
                    'cipuxRole'      => 'role',
                    'cipuxIsRole'    => 'TRUE',
                    'cipuxIsSkel'    => 'TRUE',
                    'cipuxIsShare'   => 'FALSE',
                    'cipuxFirstname' => 'Generic',
                    'cipuxLastname'  => 'Skel',
                },
            },
        },

        ### CAT module ###
        'cipux_cat_module_object' => {
            order       => ['cipux_cat_module'],
            object_attr => ['cn'],
            coupling    => {},
            overwrite   => {
                cipux_cat_module =>
                    { 'cipuxRemark' => 'CipUX object layer', },
            },
        },

        ### task ###
        'cipux_task_object' => {
            order       => ['cipux_task'],
            object_attr => ['cn'],
            coupling    => {},
            overwrite =>
                { cipux_task => { 'cipuxRemark' => 'CipUX object layer', }, },
        },

        ### room ###
        'cipux_room_object' => {
            order       => ['cipux_room'],
            object_attr => [qw(cn)],
            coupling    => {},
            overwrite   => {},
        },

        ### netgroup ###
        'cipux_netgroup_object' => {
            order       => ['cipux_netgroup'],
            object_attr => ['cn'],
            coupling    => {},
            overwrite   => {},
        },

        ### client ###
        'cipux_client_object' => {
            order       => ['cipux_client'],
            object_attr => ['cn'],
            coupling    => {},
            overwrite   => {},
        },
    },

 # +=========================================================================+
 # || CipUX Object LDAP Node Construction Section                           ||
 # +=========================================================================+

    # $cfg_object_hr
    object => {

#        'cipux_ldap_root_node' => {
#            preset => {
#                objectClass => [qw(top organizationalUnit cipuxLdapRootNode)],
#                cipuxRemark => 'CipUX object layer',
#            },
#            auto => {
#                cipuxCreationDate => 1,
#                struc_rdn         => 1,
#                base_dn           => 1,
#            },
#            mandatory => { ou => 1, },
#            rule      => { dn => 'dn: ou=<ou>,<struc_rdn>,<base_dn>', },
#            alias     => {},
#
#        },

        'cipux_ldap_orga_node' => {
            preset => {
                objectClass => [qw(top organizationalUnit cipuxLdapOrgaNode)],
                cipuxRemark => 'CipUX object layer',
            },
            auto => {
                cipuxCreationDate => 1,
                struc_rdn         => 1,
                base_dn           => 1,
            },
            mandatory => { ou => 1, },
            rule      => { dn => 'dn: ou=<ou>,<base_dn>', },
            alias     => {},
        },

        'cipux_account.user' => {
            preset => {
                objectClass => [
                    'posixAccount',  'top',
                    'shadowAccount', 'imapUser',
                    'cipuxAccount'
                ],
                cipuxFirstname      => 'CipUX',
                cipuxLastname       => 'Account',
                cipuxIsAccount      => 'TRUE',
                loginShell          => '/bin/bash',
                cipuxSoftQuota      => '40000',
                cipuxHardQuota      => '50000',
                cipuxStatus         => 'idle',
                cipuxRole           => 'none',
                cipuxSkeletonUid    => ['none'],
                cipuxInternetStatus => 'accept',
                cipuxRemark         => 'CipUX object layer',
            },
            auto => {
                uidNumber         => 1,
                userPassword      => 1,
                cipuxCreationDate => 1,
                struc_rdn         => 1,
                base_dn           => 1,
            },
            mandatory => {
                uid            => 1,
                cipuxFirstname => 1,
                cipuxLastname  => 1,
            },
            rule => {
                dn               => 'dn: uid=<uid>,<struc_rdn>,<base_dn>',
                cn               => '<cipuxFirstname> <cipuxLastname>',
                homeDirectory    => "$cipux_home_directory/<uid>",
                mailMessageStore => '/var/lib/maildirs/<uid>',
            },
            alias => {
                gidNumber => 'uidNumber',
                gecos     => 'uid'
            },
        },

        'cipux_account.group' => {
            preset => {
                objectClass         => [ 'top', 'posixGroup', 'cipuxGroup', ],
                cipuxIsAccount      => 'TRUE',
                cipuxSoftQuota      => '40000',
                cipuxHardQuota      => '50000',
                cipuxRole           => 'private',
                cipuxInternetStatus => 'accept',
                cipuxRemark => 'CipUX object layer',
            },
            auto => {
                gidNumber         => 1,
                cipuxCreationDate => 1,
                struc_rdn         => 1,
                base_dn           => 1,
            },
            mandatory => { cn => 1, },
            rule      => { dn => 'dn: cn=<cn>,<struc_rdn>,<base_dn>', },
            alias     => {
                memberUid           => 'cn',
                cipuxGroupLeaderUid => 'cn',
            },
        },

        'cipux_role.group' => {
            preset => {
                objectClass => [
                    'top',         'posixGroup',
                    'lisAclGroup', 'groupOfNames',
                    'lisGroup',    'cipuxGroup',
                ],
                cipuxIsAccount      => 'TRUE',
                cipuxSoftQuota      => '40000',
                cipuxHardQuota      => '50000',
                cipuxRole           => 'role',
                cipuxInternetStatus => 'accept',
                cipuxRemark         => 'CipUX object layer',
                member              => '',
                groupType           => 'authority_group',
            },
            auto => {
                gidNumber         => 1,
                cipuxCreationDate => 1,
                struc_rdn         => 1,
                base_dn           => 1,
            },
            mandatory => { cn => 1, },
            rule      => { dn => 'dn: cn=<cn>,<struc_rdn>,<base_dn>', },
            alias     => {
                memberUid           => 'cn',
                cipuxGroupLeaderUid => 'cn',
            },
        },

        'cipux_share.user' => {
            preset => {
                objectClass => [
                    'posixAccount',  'top',
                    'shadowAccount', 'imapUser',
                    'cipuxAccount'
                ],
                cipuxIsShare        => 'TRUE',
                cipuxFirstname      => 'CipuX',
                cipuxLastname       => 'share',
                loginShell          => '/bin/bash',
                cipuxSoftQuota      => '40000',
                cipuxHardQuota      => '50000',
                cipuxStatus         => 'idle',
                cipuxRole           => 'share',
                cipuxSkeletonUid    => ['none'],
                cipuxInternetStatus => 'accept',
                cipuxRemark         => 'CipUX object layer',
            },
            auto => {
                uidNumber         => 1,
                userPassword      => 1,
                cipuxCreationDate => 1,
                struc_rdn         => 1,
                base_dn           => 1,
            },
            mandatory => { uid => 1, },
            rule      => {
                dn               => 'dn: uid=<uid>,<struc_rdn>,<base_dn>',
                cn               => '<cipuxFirstname> <cipuxLastname>',
                homeDirectory    => "$cipux_home_directory/<uid>",
                mailMessageStore => '/var/lib/maildirs/<uid>',
            },
            alias => {
                gidNumber => 'uidNumber',
                gecos     => 'uid'
            },
        },

        'cipux_share.group' => {
            preset => {
                objectClass =>
                    [ 'top', 'posixGroup', 'cipuxGroup', 'lisGroup', ],
                cipuxIsShare        => 'TRUE',
                cipuxSoftQuota      => '40000',
                cipuxHardQuota      => '50000',
                cipuxRole           => 'private',
                cipuxInternetStatus => 'accept',
                cipuxRemark         => 'CipUX node layer',
                groupType           => 'school_class',
            },
            auto => {
                gidNumber         => 1,
                cipuxCreationDate => 1,
                struc_rdn         => 1,
                base_dn           => 1,
            },
            mandatory => { cn => 1, },
            rule      => { dn => 'dn: cn=<cn>,<struc_rdn>,<base_dn>', },
            alias     => {
                memberUid           => 'cn',
                description         => 'cn',
                cipuxGroupLeaderUid => 'cn',
            },
        },

        'cipux_room' => {
            preset => {
                objectClass => [ 'top', 'room', 'cipuxRoom', ],
                description => [' seminar room'],

                #seeAlso => ['room number'], # invalid per syntax!
                telephoneNumber      => ['000'],
                roomNumber           => ['000'],
                cipuxAddress         => ['Room e51'],
                cipuxFaculty         => ['Sociology'],
                cipuxImageSlotNumber => [' 1'],
                cipuxNetworkAddress  => ['<MANDATORY=cipuxNetworkAddress>'],
                cipuxNetworkMask     => ['<MANDATORY=cipuxNetworkMask>'],
                cipuxGatewayAddress  => ['<MANDATORY=cipuxGatewayAddress>'],
                cipuxGatewayMask     => ['<MANDATORY=cipuxGatewayMask>'],
            },
            auto => {
                struc_rdn => 1,
                base_dn   => 1,
            },
            mandatory => { cn => 1, },
            rule      => { dn => 'dn: cn=<cn>,<struc_rdn>,<base_dn>', },
            alias     => {},
        },

        'cipux_netgroup' => {
            preset => {
                objectClass => [ 'top', 'nisNetgroup' ],
                description => ['netgroup'],
            },
            auto => {
                struc_rdn => 1,
                base_dn   => 1,
            },
            mandatory => { cn => 1, },
            rule      => { dn => 'dn: cn=<cn>,<struc_rdn>,<base_dn>', },
            alias     => {},
        },

        'cipux_client' => {
            preset => {
                objectClass => [
                    'top',                 'organizationalRole',
                    'domainRelatedObject', 'ipHost',
                    'ieee802Device',       'cipuxMachine'
                ],
                ipHostNumber => '',
            },
            auto => {
                struc_rdn => 1,
                base_dn   => 1,
            },
            mandatory => {
                cn               => 1,
                associatedDomain => 1,
                ipHostNumber     => 1,
                macAddress       => 1,
            },
            rule => {
                dn               => 'dn: cn=<cn>,<struc_rdn>,<base_dn>',
                ipHostNumber     => '<ipHostNumber>',
                associatedDomain => '<associatedDomain>',
                macAddress       => '<macAddress>',
            },
            alias => {},
        },

        'cipux_cat_module' => {
            preset => {
                objectClass =>
                    [ 'top', 'cipuxApplication', 'cipuxCatModule', ],
                cipuxName             => ['unkown'],
                cipuxTemplateDir      => => 1,
                cipuxAuthor           => ['Unknown'],
                cipuxLicense          => ['GPLv2 or later'],
                cipuxScript           => ['preset_name.cgi'],
                cipuxIsEnabled        => ['FALSE'],
                cipuxMemberRid        => 'admin',
                cipuxModality         => ['none'],
                cipuxShortDescription => ['none'],
                cipuxYear             => ['2008'],
                cipuxEntity           => ['none'],
                cipuxIsModuleArray    => ['FALSE'],
                cipuxIcon             => ['shell.png'],
            },
            auto => {
                struc_rdn => 1,
                base_dn   => 1,
            },

            # you have to list all mandatoy attributes, see LDAP schema
            # otherwise you can not add that object CipUX::Object::mandatory
            mandatory => {
                cn                    => 1,
                cipuxName             => 1,
                cipuxTemplate         => 1,
                cipuxTemplateDir      => 1,
                cipuxEntity           => 1,
                cipuxModality         => 1,
                cipuxIsModuleArray    => 1,
                cipuxAuthor           => 1,
                cipuxLicense          => 1,
                cipuxScript           => 1,
                cipuxIcon             => 1,
                cipuxYear             => 1,
                cipuxShortDescription => 1,
                cipuxMemberRid        => 1,
                cipuxIsEnabled        => 1,
            },
            rule => { dn => 'dn: cn=<cn>,<struc_rdn>,<base_dn>', },

            # FIXME: merge it
            alias => { 'cipuxScript'   => 'cn', },
            alias => { 'cipuxModality' => 'cn', },
            alias => { 'cipuxTemplate' => 'cn', },
        },

        'cipux_task' => {
            preset => {
                objectClass    => [ 'top', 'cipuxTask' ],
                cipuxName      => ['unkown'],
                cipuxIsEnabled => ['TRUE'],
                cipuxMemberPid =>
                    [ 'cipux_rpc_test_client', 'cipux_rpc_test_repetition', ],

                cipuxShortDescription => ['none'],
            },
            auto => {
                cipuxCreationDate => 1,
                struc_rdn         => 1,
                base_dn           => 1,
            },

            # you have to list all mandatoy attributes, see LDAP schema
            # otherwise you can not add that object CipUX::Object::mandatory
            mandatory => {
                cn                    => 1,
                cipuxName             => 1,
                cipuxIsEnabled        => 1,
                cipuxShortDescription => 1,
                cipuxShortDescription => 1,
            },
            rule  => { dn          => 'dn: cn=<cn>,<struc_rdn>,<base_dn>', },
            alias => { 'cipuxName' => 'cn', },
        },

    },

 # +=========================================================================+
 # || CipUX Object LDAP Node Construction Section                           ||
 # +=========================================================================+
 # $cfg_object_hr2
 # TODO: probably better to source that out to cipux.ini

    basis => {

        # the start of counting uidNumber, gidNumber for objects
        oidNumberBegin => 11000,

        # the stop of counting uidNumber, gidNumber for objects
        oidNumberEnd => 41000,

    },
};

