/*
   cipelib - library routines common to CIPE (user-mode part) and PKCIPE

   Copyright 2000 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: socks5_internal.h,v 1.4 2000/12/05 19:21:12 olaf Exp $ */

#ifndef __GNUC__
#warning "struct socksrq may be misaligned, fix me"
#endif

struct socksrq {
    char		ver;
    char		cmd;
    char		rsv;
    char		atyp;
    unsigned int	dstaddr __attribute__((packed));
    unsigned short	dstport __attribute__((packed));
};

INLINE int readn(int fd, char *b, int n, const char *m)
{
    int e=xread(fd, b, n);
    if (e<0)
	cipe_syslog(LOG_ERR, "%s: %m", m);
    return e;
}

INLINE int writen(int fd, char *b, int n, const char *m)
{
    int e=xwrite(fd, b, n);
    if (e<0)
	cipe_syslog(LOG_ERR, "%s: %m", m);
    return e;
}

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif

