/*
 * Br2HdrManagerGui.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright (c) 2005-2006  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  Br2HdrManagerGui.hpp
*/
#ifndef Br2HdrManagerGui_hpp
#define Br2HdrManagerGui_hpp


#include <FL/Fl.H>              // Fl::flush()
#include <FL/fl_draw.H>         // fl_cursor()
#include "../br_core/Br2HdrManager.hpp"


namespace br {

/**===========================================================================

  @class  Br2HdrManagerGui

  Implements the "abstract" GUI methods of <tt>Br2HdrManager</tt>. 

*============================================================================*/
class Br2HdrManagerGui : public Br2HdrManager
{
public:
    Br2HdrManagerGui()  {}

    void cursor_wait() {
        fl_cursor(FL_CURSOR_WAIT); 
        Fl::flush();            // otherwise wait cursor sometimes not shown
      }
      
    void cursor_default() {
        fl_cursor(FL_CURSOR_DEFAULT);
      }
};


}  // namespace

#endif  // Br2HdrManagerGui_hpp

// END OF FILE
