/*
 * testtools.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright (c) 2005-2006  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
   testtools.hpp
*/
#ifndef testtools_hpp
#define testtools_hpp

#include "Br2HdrManager.hpp"

namespace br {

void add_TestImages            (Br2HdrManager &, int xdim, int ydim, int N, ImageType);
void add_TestImages_RGB_U8     (Br2HdrManager &, int xdim, int ydim, int N);
void add_TestImages_RGB_U16    (Br2HdrManager &, int xdim, int ydim, int N);

void add_BadImages             (Br2HdrManager &, int xdim, int ydim, int N, ImageType);
void add_BadImages_RGB_U8      (Br2HdrManager &, int xdim, int ydim, int N);
void add_BadImages_RGB_U16     (Br2HdrManager &, int xdim, int ydim, int N);

void add_SlopeXYImages         (Br2HdrManager &, int xdim, int ydim, int N, ImageType);
void add_SlopeXYImages_RGB_U8  (Br2HdrManager &, int xdim, int ydim, int N);
void add_SlopeXYImages_RGB_U16 (Br2HdrManager &, int xdim, int ydim, int N);

}  // namespace

#endif  // testtools_hpp

// END OF FILE
