/*
 * Scheme2D.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright (c) 2005-2006  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  Scheme2D.hpp
*/
#ifndef Scheme2D_hpp
#define Scheme2D_hpp


/**============================================================================

  @class Scheme2D  -  class template
 
  Typecasted 2D-view on a void* buffer. Provides "[][]" access syntax. In addition
   a 1D-view is provided by `view1d(). Copying allowed (default Copy-Ctor and
   =-Op do the right).

=============================================================================*/
template <typename T>
class Scheme2D
{
    int  dim1_;                 // number of rows (outer dimension)
    int  dim2_;                 // number of columns (inner dimension)
    T*   data_;                 // points to the data begin

public:

    Scheme2D() : dim1_(0), dim2_(0), data_(0)    // Default Ctor useful for vectors
      {}
    Scheme2D (int dim1, int dim2, void* buf) 
      : dim1_ (dim1),
        dim2_ (dim2),
        data_ ((T*)buf)
      {}
    Scheme2D (int dim1, int dim2, const void* buf) 
      : dim1_ (dim1),
        dim2_ (dim2),
        data_ ((T*)buf)
      {}
    
    int dim1() const                  {return dim1_;}
    int dim2() const                  {return dim2_;}
    int size() const                  {return dim1_ * dim2_;}
    
    const T* operator[] (int i) const {return & data_[ i * dim2_ ];}
    T*       operator[] (int i)       {return & data_[ i * dim2_ ];}
#if 0   
    const T& Ref (int i, int j) const {return data_[ i * dim2_ + j ];}
    T&       Ref (int i, int j)       {return data_[ i * dim2_ + j ];}
#endif    
    operator const T*() const         {return data_;}   // Cast op
    operator T*()                     {return data_;}
    
    const T& view1d (int i) const     {return data_[i];}
    T&       view1d (int i)           {return data_[i];}  
};



#endif  // Scheme2D_hpp

// END OF FILE
