# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""This module provides a set of tools that I-Spy uses to perform tests.


I-Spy breaks rendering-validations down into a hierarchy of batches,
 tests, and failures.
 A batch is a group of tests that is run together.
 A test consists of two images, one image of the page that is known
  to be rendered correctly, and another that is a white and black mask,
  where white regions represent areas that should be exempted from pixel-
  by-pixel comparisons. These masks are generated by taking a
  succession of images from a view which is  known to be rendered correctly,
  and masking the regions that change to prevent animated regions of the
  page from breaking the tests. Tests can be run by submitting an image to
  them. The submitted image will be compared against the regions of the
  test's image (which is known to be rendered correctly) that are not
  excluded by the test's mask. If the comparison fails, a failure is stored
  in Google Cloud Storage.
 A failure consists of the image which failed to compare to the test's image
  and mask, and a black and white image representing the difference between
  the failure's image and the test's."""
