# Copyright (c) 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'browser_extensions',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      # Since browser and browser_extensions actually depend on each other,
      # we must omit the dependency from browser_extensions to browser.
      # However, this means browser_extensions and browser should more or less
      # have the same dependencies. Once browser_extensions is untangled from
      # browser, then we can clean up these dependencies.
      'dependencies': [
        'chrome_resources.gyp:chrome_extra_resources',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:platform_locale_settings',
        'chrome_resources.gyp:theme_resources',
        'common',
        'common/extensions/api/api.gyp:api',
        'common_net',
        'debugger',
        'in_memory_url_index_cache_proto',
        'installer_util',
        '../content/content.gyp:content_browser',
        '../crypto/crypto.gyp:crypto',
        '../device/bluetooth/bluetooth.gyp:device_bluetooth',
        '../net/net.gyp:net',
        '../skia/skia.gyp:skia',
        '../sync/sync.gyp:sync',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../third_party/libusb/libusb.gyp:libusb',
        '../third_party/re2/re2.gyp:re2',
        '../third_party/webrtc/modules/modules.gyp:desktop_capture',
        '../ui/base/strings/ui_strings.gyp:ui_strings',
        '../ui/ui.gyp:ui',
        '../ui/ui.gyp:ui_resources',
        '../url/url.gyp:url_lib',
        '../webkit/common/user_agent/webkit_user_agent.gyp:user_agent',
        '../webkit/storage_browser.gyp:webkit_storage_browser',
        '../webkit/storage_common.gyp:webkit_storage_common',
        '../webkit/webkit_resources.gyp:webkit_resources',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
      ],
      'sources': [
        # All .cc, .h, .m, and .mm files under browser/extensions except for
        # tests and mocks.
        '../extensions/browser/extension_prefs_scope.h',
        '../extensions/browser/extension_error.cc',
        '../extensions/browser/extension_error.h',
        '../extensions/browser/file_highlighter.cc',
        '../extensions/browser/file_highlighter.h',
        '../extensions/browser/file_reader.cc',
        '../extensions/browser/file_reader.h',
        '../extensions/browser/pref_names.cc',
        '../extensions/browser/pref_names.h',
        '../extensions/browser/view_type_utils.cc',
        '../extensions/browser/view_type_utils.h',
        'browser/apps/app_url_redirector.cc',
        'browser/apps/app_url_redirector.h',
        'browser/apps/chrome_apps_client.cc',
        'browser/apps/chrome_apps_client.h',
        'browser/apps/shortcut_manager.cc',
        'browser/apps/shortcut_manager.h',
        'browser/apps/shortcut_manager_factory.cc',
        'browser/apps/shortcut_manager_factory.h',
        'browser/extensions/active_tab_permission_granter.cc',
        'browser/extensions/active_tab_permission_granter.h',
        'browser/extensions/activity_log/activity_action_constants.cc',
        'browser/extensions/activity_log/activity_action_constants.h',
        'browser/extensions/activity_log/activity_actions.cc',
        'browser/extensions/activity_log/activity_actions.h',
        'browser/extensions/activity_log/activity_database.cc',
        'browser/extensions/activity_log/activity_database.h',
        'browser/extensions/activity_log/activity_log.cc',
        'browser/extensions/activity_log/activity_log.h',
        'browser/extensions/activity_log/activity_log_policy.cc',
        'browser/extensions/activity_log/activity_log_policy.h',
        'browser/extensions/activity_log/counting_policy.cc',
        'browser/extensions/activity_log/counting_policy.h',
        'browser/extensions/activity_log/database_string_table.cc',
        'browser/extensions/activity_log/database_string_table.h',
        'browser/extensions/activity_log/fullstream_ui_policy.cc',
        'browser/extensions/activity_log/fullstream_ui_policy.h',
        'browser/extensions/activity_log/uma_policy.cc',
        'browser/extensions/activity_log/uma_policy.h',
        'browser/extensions/activity_log/web_request_constants.cc',
        'browser/extensions/activity_log/web_request_constants.h',
        'browser/extensions/admin_policy.cc',
        'browser/extensions/admin_policy.h',
        'browser/extensions/api/activity_log_private/activity_log_private_api.cc',
        'browser/extensions/api/activity_log_private/activity_log_private_api.h',
        'browser/extensions/api/api_function.cc',
        'browser/extensions/api/api_function.h',
        'browser/extensions/api/api_resource.cc',
        'browser/extensions/api/api_resource.h',
        'browser/extensions/api/api_resource_manager.h',
        'browser/extensions/api/alarms/alarm_manager.cc',
        'browser/extensions/api/alarms/alarm_manager.h',
        'browser/extensions/api/alarms/alarms_api.cc',
        'browser/extensions/api/alarms/alarms_api.h',
        'browser/extensions/api/app_current_window_internal/app_current_window_internal_api.cc',
        'browser/extensions/api/app_current_window_internal/app_current_window_internal_api.h',
        'browser/extensions/api/app_runtime/app_runtime_api.cc',
        'browser/extensions/api/app_runtime/app_runtime_api.h',
        'browser/extensions/api/app_window/app_window_api.cc',
        'browser/extensions/api/app_window/app_window_api.h',
        'browser/extensions/api/audio/audio_api.cc',
        'browser/extensions/api/audio/audio_api.h',
        'browser/extensions/api/audio/audio_service.cc',
        'browser/extensions/api/audio/audio_service.h',
        'browser/extensions/api/audio/audio_service_chromeos.cc',
        'browser/extensions/api/autotest_private/autotest_private_api.cc',
        'browser/extensions/api/autotest_private/autotest_private_api.h',
        'browser/extensions/api/autotest_private/autotest_private_api_factory.cc',
        'browser/extensions/api/autotest_private/autotest_private_api_factory.h',
        'browser/extensions/api/bluetooth/bluetooth_api.cc',
        'browser/extensions/api/bluetooth/bluetooth_api.h',
        'browser/extensions/api/bluetooth/bluetooth_api_factory.cc',
        'browser/extensions/api/bluetooth/bluetooth_api_factory.h',
        'browser/extensions/api/bluetooth/bluetooth_api_utils.cc',
        'browser/extensions/api/bluetooth/bluetooth_api_utils.h',
        'browser/extensions/api/bluetooth/bluetooth_event_router.cc',
        'browser/extensions/api/bluetooth/bluetooth_event_router.h',
        'browser/extensions/api/bluetooth/bluetooth_extension_function.cc',
        'browser/extensions/api/bluetooth/bluetooth_extension_function.h',
        'browser/extensions/api/bookmark_manager_private/bookmark_manager_private_api.cc',
        'browser/extensions/api/bookmark_manager_private/bookmark_manager_private_api.h',
        'browser/extensions/api/bookmark_manager_private/bookmark_manager_private_api_constants.cc',
        'browser/extensions/api/bookmark_manager_private/bookmark_manager_private_api_constants.h',
        'browser/extensions/api/bookmarks/bookmark_api_constants.cc',
        'browser/extensions/api/bookmarks/bookmark_api_constants.h',
        'browser/extensions/api/bookmarks/bookmark_api_helpers.cc',
        'browser/extensions/api/bookmarks/bookmark_api_helpers.h',
        'browser/extensions/api/bookmarks/bookmarks_api.cc',
        'browser/extensions/api/bookmarks/bookmarks_api.h',
        'browser/extensions/api/braille_display_private/braille_controller_brlapi.cc',
        'browser/extensions/api/braille_display_private/braille_controller_brlapi.h',
        'browser/extensions/api/braille_display_private/braille_controller_stub.cc',
        'browser/extensions/api/braille_display_private/braille_controller.h',
        'browser/extensions/api/braille_display_private/braille_display_private_api.h',
        'browser/extensions/api/braille_display_private/braille_display_private_api.cc',
        'browser/extensions/api/braille_display_private/brlapi_connection.cc',
        'browser/extensions/api/braille_display_private/brlapi_connection.h',
        'browser/extensions/api/browsing_data/browsing_data_api.cc',
        'browser/extensions/api/browsing_data/browsing_data_api.h',
        'browser/extensions/api/cloud_print_private/cloud_print_private_api.cc',
        'browser/extensions/api/cloud_print_private/cloud_print_private_api.h',
        'browser/extensions/api/command_line_private/command_line_private_api.cc',
        'browser/extensions/api/command_line_private/command_line_private_api.h',
        'browser/extensions/api/commands/command_service.cc',
        'browser/extensions/api/commands/command_service.h',
        'browser/extensions/api/content_settings/content_settings_api.cc',
        'browser/extensions/api/content_settings/content_settings_api.h',
        'browser/extensions/api/content_settings/content_settings_api_constants.cc',
        'browser/extensions/api/content_settings/content_settings_api_constants.h',
        'browser/extensions/api/content_settings/content_settings_helpers.cc',
        'browser/extensions/api/content_settings/content_settings_helpers.h',
        'browser/extensions/api/content_settings/content_settings_store.cc',
        'browser/extensions/api/content_settings/content_settings_store.h',
        'browser/extensions/api/commands/commands.cc',
        'browser/extensions/api/commands/commands.h',
        'browser/extensions/api/context_menus/context_menus_api.cc',
        'browser/extensions/api/context_menus/context_menus_api.h',
        'browser/extensions/api/cookies/cookies_api.cc',
        'browser/extensions/api/cookies/cookies_api.h',
        'browser/extensions/api/cookies/cookies_api_constants.cc',
        'browser/extensions/api/cookies/cookies_api_constants.h',
        'browser/extensions/api/cookies/cookies_helpers.cc',
        'browser/extensions/api/cookies/cookies_helpers.h',
        'browser/extensions/api/debugger/debugger_api.cc',
        'browser/extensions/api/debugger/debugger_api.h',
        'browser/extensions/api/debugger/debugger_api_constants.cc',
        'browser/extensions/api/debugger/debugger_api_constants.h',
        'browser/extensions/api/declarative/deduping_factory.h',
        'browser/extensions/api/declarative/declarative_api.cc',
        'browser/extensions/api/declarative/declarative_api.h',
        'browser/extensions/api/declarative/declarative_rule.h',
        'browser/extensions/api/declarative/initializing_rules_registry.cc',
        'browser/extensions/api/declarative/initializing_rules_registry.h',
        'browser/extensions/api/declarative/rules_registry.h',
        'browser/extensions/api/declarative/rules_registry_service.cc',
        'browser/extensions/api/declarative/rules_registry_service.h',
        'browser/extensions/api/declarative/rules_registry_with_cache.cc',
        'browser/extensions/api/declarative/rules_registry_with_cache.h',
        'browser/extensions/api/declarative/test_rules_registry.cc',
        'browser/extensions/api/declarative/test_rules_registry.h',
        'browser/extensions/api/declarative_content/content_action.cc',
        'browser/extensions/api/declarative_content/content_action.h',
        'browser/extensions/api/declarative_content/content_condition.cc',
        'browser/extensions/api/declarative_content/content_condition.h',
        'browser/extensions/api/declarative_content/content_constants.cc',
        'browser/extensions/api/declarative_content/content_constants.h',
        'browser/extensions/api/declarative_content/content_rules_registry.cc',
        'browser/extensions/api/declarative_content/content_rules_registry.h',
        'browser/extensions/api/declarative_webrequest/request_stage.cc',
        'browser/extensions/api/declarative_webrequest/request_stage.h',
        'browser/extensions/api/declarative_webrequest/webrequest_action.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_action.h',
        'browser/extensions/api/declarative_webrequest/webrequest_condition.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_condition.h',
        'browser/extensions/api/declarative_webrequest/webrequest_condition_attribute.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_condition_attribute.h',
        'browser/extensions/api/declarative_webrequest/webrequest_constants.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_constants.h',
        'browser/extensions/api/declarative_webrequest/webrequest_rules_registry.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_rules_registry.h',
        'browser/extensions/api/desktop_capture/desktop_capture_api.cc',
        'browser/extensions/api/desktop_capture/desktop_capture_api.h',
        'browser/extensions/api/developer_private/developer_private_api.cc',
        'browser/extensions/api/developer_private/developer_private_api.h',
        'browser/extensions/api/developer_private/developer_private_api_factory.cc',
        'browser/extensions/api/developer_private/developer_private_api_factory.h',
        'browser/extensions/api/developer_private/entry_picker.cc',
        'browser/extensions/api/developer_private/entry_picker.h',
        'browser/extensions/api/dial/dial_api.cc',
        'browser/extensions/api/dial/dial_api.h',
        'browser/extensions/api/dial/dial_api_factory.cc',
        'browser/extensions/api/dial/dial_api_factory.h',
        'browser/extensions/api/dial/dial_device_data.cc',
        'browser/extensions/api/dial/dial_device_data.h',
        'browser/extensions/api/dial/dial_registry.cc',
        'browser/extensions/api/dial/dial_registry.h',
        'browser/extensions/api/dial/dial_service.cc',
        'browser/extensions/api/dial/dial_service.h',
        'browser/extensions/api/discovery/discovery_api.cc',
        'browser/extensions/api/discovery/discovery_api.h',
        'browser/extensions/api/discovery/suggested_link.cc',
        'browser/extensions/api/discovery/suggested_link.h',
        'browser/extensions/api/discovery/suggested_links_registry.cc',
        'browser/extensions/api/discovery/suggested_links_registry.h',
        'browser/extensions/api/discovery/suggested_links_registry_factory.cc',
        'browser/extensions/api/discovery/suggested_links_registry_factory.h',
        'browser/extensions/api/dns/dns_api.cc',
        'browser/extensions/api/dns/dns_api.h',
        'browser/extensions/api/dns/host_resolver_wrapper.cc',
        'browser/extensions/api/dns/host_resolver_wrapper.h',
        'browser/extensions/api/downloads/downloads_api.cc',
        'browser/extensions/api/downloads/downloads_api.h',
        'browser/extensions/api/extension_action/extension_action_api.cc',
        'browser/extensions/api/extension_action/extension_action_api.h',
        'browser/extensions/api/downloads_internal/downloads_internal_api.cc',
        'browser/extensions/api/downloads_internal/downloads_internal_api.h',
        'browser/extensions/api/execute_code_function.cc',
        'browser/extensions/api/execute_code_function.h',
        'browser/extensions/api/extension_action/extension_page_actions_api_constants.cc',
        'browser/extensions/api/extension_action/extension_page_actions_api_constants.h',
        'browser/extensions/api/feedback_private/blob_reader.cc',
        'browser/extensions/api/feedback_private/blob_reader.h',
        'browser/extensions/api/feedback_private/feedback_private_api.cc',
        'browser/extensions/api/feedback_private/feedback_private_api.h',
        'browser/extensions/api/feedback_private/feedback_service.cc',
        'browser/extensions/api/feedback_private/feedback_service.h',
        'browser/extensions/api/feedback_private/feedback_service_chromeos.cc',
        'browser/extensions/api/feedback_private/feedback_service_nonchromeos.cc',
        'browser/extensions/api/file_handlers/app_file_handler_util.cc',
        'browser/extensions/api/file_handlers/app_file_handler_util.h',
        'browser/extensions/api/file_system/file_system_api.cc',
        'browser/extensions/api/file_system/file_system_api.h',
        'browser/extensions/api/font_settings/font_settings_api.cc',
        'browser/extensions/api/font_settings/font_settings_api.h',
        'browser/extensions/api/history/history_api.h',
        'browser/extensions/api/history/history_api.cc',
        'browser/extensions/api/i18n/i18n_api.cc',
        'browser/extensions/api/i18n/i18n_api.h',
        'browser/extensions/api/identity/experimental_identity_api.cc',
        'browser/extensions/api/identity/experimental_identity_api.h',
        'browser/extensions/api/identity/experimental_web_auth_flow.cc',
        'browser/extensions/api/identity/experimental_web_auth_flow.h',
        'browser/extensions/api/identity/gaia_web_auth_flow.cc',
        'browser/extensions/api/identity/gaia_web_auth_flow.h',
        'browser/extensions/api/identity/identity_api.cc',
        'browser/extensions/api/identity/identity_api.h',
        'browser/extensions/api/identity/identity_mint_queue.cc',
        'browser/extensions/api/identity/identity_mint_queue.h',
        'browser/extensions/api/identity/identity_signin_flow.cc',
        'browser/extensions/api/identity/identity_signin_flow.h',
        'browser/extensions/api/identity/web_auth_flow.cc',
        'browser/extensions/api/identity/web_auth_flow.h',
        'browser/extensions/api/identity_private/identity_private_api.cc',
        'browser/extensions/api/identity_private/identity_private_api.h',
        'browser/extensions/api/idle/idle_api.cc',
        'browser/extensions/api/idle/idle_api.h',
        'browser/extensions/api/idle/idle_api_constants.cc',
        'browser/extensions/api/idle/idle_api_constants.h',
        'browser/extensions/api/idle/idle_manager.cc',
        'browser/extensions/api/idle/idle_manager.h',
        'browser/extensions/api/idle/idle_manager_factory.cc',
        'browser/extensions/api/idle/idle_manager_factory.h',
        'browser/extensions/api/idltest/idltest_api.cc',
        'browser/extensions/api/idltest/idltest_api.h',
        'browser/extensions/api/image_writer_private/error_messages.cc',
        'browser/extensions/api/image_writer_private/error_messages.h',
        'browser/extensions/api/image_writer_private/operation.cc',
        'browser/extensions/api/image_writer_private/operation_chromeos.cc',
        'browser/extensions/api/image_writer_private/operation.h',
        'browser/extensions/api/image_writer_private/operation_linux.cc',
        'browser/extensions/api/image_writer_private/operation_mac.cc',
        'browser/extensions/api/image_writer_private/operation_manager.cc',
        'browser/extensions/api/image_writer_private/operation_manager.h',
        'browser/extensions/api/image_writer_private/operation_win.cc',
        'browser/extensions/api/image_writer_private/image_writer_private_api.cc',
        'browser/extensions/api/image_writer_private/image_writer_private_api.h',
        'browser/extensions/api/image_writer_private/image_writer_utils.cc',
        'browser/extensions/api/image_writer_private/image_writer_utils.h',
        'browser/extensions/api/image_writer_private/removable_storage_provider.h',
        'browser/extensions/api/image_writer_private/removable_storage_provider_linux.cc',
        'browser/extensions/api/image_writer_private/removable_storage_provider_mac.cc',
        'browser/extensions/api/image_writer_private/removable_storage_provider_win.cc',
        'browser/extensions/api/image_writer_private/write_from_file_operation.cc',
        'browser/extensions/api/image_writer_private/write_from_file_operation.h',
        'browser/extensions/api/image_writer_private/write_from_url_operation.cc',
        'browser/extensions/api/image_writer_private/write_from_url_operation.h',
        'browser/extensions/api/input/input.cc',
        'browser/extensions/api/input/input.h',
        'browser/extensions/api/location/location_api.cc',
        'browser/extensions/api/location/location_api.h',
        'browser/extensions/api/location/location_manager.cc',
        'browser/extensions/api/location/location_manager.h',
        'browser/extensions/api/log_private/filter_handler.cc',
        'browser/extensions/api/log_private/filter_handler.h',
        'browser/extensions/api/log_private/log_parser.cc',
        'browser/extensions/api/log_private/log_parser.h',
        'browser/extensions/api/log_private/log_private_api.h',
        'browser/extensions/api/log_private/log_private_api_nonchromeos.cc',
        'browser/extensions/api/log_private/syslog_parser.cc',
        'browser/extensions/api/log_private/syslog_parser.h',
        'browser/extensions/api/management/management_api.cc',
        'browser/extensions/api/management/management_api.h',
        'browser/extensions/api/management/management_api_constants.cc',
        'browser/extensions/api/management/management_api_constants.h',
        'browser/extensions/api/media_galleries/media_galleries_api.cc',
        'browser/extensions/api/media_galleries/media_galleries_api.h',
        'browser/extensions/api/media_galleries_private/gallery_watch_manager.cc',
        'browser/extensions/api/media_galleries_private/gallery_watch_manager.h',
        'browser/extensions/api/media_galleries_private/gallery_watch_state_tracker.cc',
        'browser/extensions/api/media_galleries_private/gallery_watch_state_tracker.h',
        'browser/extensions/api/media_galleries_private/media_galleries_private_api.cc',
        'browser/extensions/api/media_galleries_private/media_galleries_private_api.h',
        'browser/extensions/api/media_galleries_private/media_galleries_private_event_router.cc',
        'browser/extensions/api/media_galleries_private/media_galleries_private_event_router.h',
        'browser/extensions/api/messaging/extension_message_port.cc',
        'browser/extensions/api/messaging/extension_message_port.h',
        'browser/extensions/api/messaging/message_service.cc',
        'browser/extensions/api/messaging/message_service.h',
        'browser/extensions/api/messaging/native_message_process_host.cc',
        'browser/extensions/api/messaging/native_message_process_host.h',
        'browser/extensions/api/messaging/native_process_launcher_posix.cc',
        'browser/extensions/api/messaging/native_process_launcher_win.cc',
        'browser/extensions/api/messaging/native_process_launcher.cc',
        'browser/extensions/api/messaging/native_process_launcher.h',
        'browser/extensions/api/messaging/native_messaging_host_manifest.cc',
        'browser/extensions/api/messaging/native_messaging_host_manifest.h',
        'browser/extensions/api/messaging/native_message_port.cc',
        'browser/extensions/api/messaging/native_message_port.h',
        'browser/extensions/api/metrics_private/metrics_private_api.cc',
        'browser/extensions/api/metrics_private/metrics_private_api.h',
        'browser/extensions/api/mdns/dns_sd_delegate.h',
        'browser/extensions/api/mdns/dns_sd_delegate.cc',
        'browser/extensions/api/mdns/dns_sd_device_lister.h',
        'browser/extensions/api/mdns/dns_sd_device_lister.cc',
        'browser/extensions/api/mdns/dns_sd_registry.h',
        'browser/extensions/api/mdns/dns_sd_registry.cc',
        'browser/extensions/api/mdns/mdns_api.h',
        'browser/extensions/api/mdns/mdns_api.cc',
        'browser/extensions/api/module/module.cc',
        'browser/extensions/api/module/module.h',
        'browser/extensions/api/music_manager_private/device_id.cc',
        'browser/extensions/api/music_manager_private/device_id.h',
        'browser/extensions/api/music_manager_private/device_id_chromeos.cc',
        'browser/extensions/api/music_manager_private/device_id_linux.cc',
        'browser/extensions/api/music_manager_private/device_id_mac.cc',
        'browser/extensions/api/music_manager_private/device_id_win.cc',
        'browser/extensions/api/music_manager_private/music_manager_private_api.cc',
        'browser/extensions/api/music_manager_private/music_manager_private_api.h',
        'browser/extensions/api/networking_private/networking_private_api_chromeos.cc',
        'browser/extensions/api/networking_private/networking_private_api_nonchromeos.cc',
        'browser/extensions/api/networking_private/networking_private_api.h',
        'browser/extensions/api/networking_private/networking_private_crypto.cc',
        'browser/extensions/api/networking_private/networking_private_crypto.h',
        'browser/extensions/api/networking_private/networking_private_event_router_chromeos.cc',
        'browser/extensions/api/networking_private/networking_private_event_router.h',
        'browser/extensions/api/networking_private/networking_private_event_router_factory.cc',
        'browser/extensions/api/networking_private/networking_private_event_router_factory.h',
        'browser/extensions/api/notifications/notifications_api.cc',
        'browser/extensions/api/notifications/notifications_api.h',
        'browser/extensions/api/omnibox/omnibox_api.cc',
        'browser/extensions/api/omnibox/omnibox_api.h',
        'browser/extensions/api/page_capture/page_capture_api.cc',
        'browser/extensions/api/page_capture/page_capture_api.h',
        'browser/extensions/api/permissions/permissions_api.cc',
        'browser/extensions/api/permissions/permissions_api.h',
        'browser/extensions/api/permissions/permissions_api_helpers.cc',
        'browser/extensions/api/permissions/permissions_api_helpers.h',
        'browser/extensions/api/diagnostics/diagnostics_api.cc',
        'browser/extensions/api/diagnostics/diagnostics_api.h',
        'browser/extensions/api/diagnostics/diagnostics_api_nonchromeos.cc',
        'browser/extensions/api/diagnostics/diagnostics_api_chromeos.cc',
        'browser/extensions/api/power/power_api.cc',
        'browser/extensions/api/power/power_api.h',
        'browser/extensions/api/power/power_api_manager.cc',
        'browser/extensions/api/power/power_api_manager.h',
        'browser/extensions/api/preference/chrome_direct_setting.cc',
        'browser/extensions/api/preference/chrome_direct_setting.h',
        'browser/extensions/api/preference/chrome_direct_setting_api.cc',
        'browser/extensions/api/preference/chrome_direct_setting_api.h',
        'browser/extensions/api/preference/preference_api.cc',
        'browser/extensions/api/preference/preference_api.h',
        'browser/extensions/api/preference/preference_api_constants.cc',
        'browser/extensions/api/preference/preference_api_constants.h',
        'browser/extensions/api/preference/preference_helpers.cc',
        'browser/extensions/api/preference/preference_helpers.h',
        'browser/extensions/api/processes/processes_api.cc',
        'browser/extensions/api/processes/processes_api.h',
        'browser/extensions/api/processes/processes_api_constants.cc',
        'browser/extensions/api/processes/processes_api_constants.h',
        'browser/extensions/api/profile_keyed_api_factory.h',
        'browser/extensions/api/proxy/proxy_api.cc',
        'browser/extensions/api/proxy/proxy_api.h',
        'browser/extensions/api/proxy/proxy_api_constants.cc',
        'browser/extensions/api/proxy/proxy_api_constants.h',
        'browser/extensions/api/proxy/proxy_api_helpers.cc',
        'browser/extensions/api/proxy/proxy_api_helpers.h',
        'browser/extensions/api/push_messaging/obfuscated_gaia_id_fetcher.cc',
        'browser/extensions/api/push_messaging/obfuscated_gaia_id_fetcher.h',
        'browser/extensions/api/push_messaging/push_messaging_api.cc',
        'browser/extensions/api/push_messaging/push_messaging_api.h',
        'browser/extensions/api/push_messaging/push_messaging_invalidation_handler.cc',
        'browser/extensions/api/push_messaging/push_messaging_invalidation_handler.h',
        'browser/extensions/api/push_messaging/push_messaging_invalidation_handler_delegate.h',
        'browser/extensions/api/push_messaging/push_messaging_invalidation_mapper.h',
        'browser/extensions/api/runtime/runtime_api.cc',
        'browser/extensions/api/runtime/runtime_api.h',
        'browser/extensions/api/serial/serial_api.cc',
        'browser/extensions/api/serial/serial_api.h',
        'browser/extensions/api/serial/serial_connection.cc',
        'browser/extensions/api/serial/serial_connection.h',
        'browser/extensions/api/serial/serial_connection_posix.cc',
        'browser/extensions/api/serial/serial_connection_win.cc',
        'browser/extensions/api/serial/serial_port_enumerator.cc',
        'browser/extensions/api/serial/serial_port_enumerator.h',
        'browser/extensions/api/serial/serial_port_enumerator_posix.cc',
        'browser/extensions/api/serial/serial_port_enumerator_win.cc',
        'browser/extensions/api/sessions/sessions_api.cc',
        'browser/extensions/api/sessions/sessions_api.h',
        'browser/extensions/api/sessions/session_id.cc',
        'browser/extensions/api/sessions/session_id.h',
        'browser/extensions/api/signed_in_devices/id_mapping_helper.cc',
        'browser/extensions/api/signed_in_devices/id_mapping_helper.h',
        'browser/extensions/api/signed_in_devices/signed_in_devices_api.cc',
        'browser/extensions/api/signed_in_devices/signed_in_devices_api.h',
        'browser/extensions/api/signed_in_devices/signed_in_devices_manager.cc',
        'browser/extensions/api/signed_in_devices/signed_in_devices_manager.h',
        'browser/extensions/api/socket/socket.cc',
        'browser/extensions/api/socket/socket.h',
        'browser/extensions/api/socket/socket_api.cc',
        'browser/extensions/api/socket/socket_api.h',
        'browser/extensions/api/socket/tcp_socket.cc',
        'browser/extensions/api/socket/tcp_socket.h',
        'browser/extensions/api/socket/udp_socket.cc',
        'browser/extensions/api/socket/udp_socket.h',
        'browser/extensions/api/sockets_udp/udp_socket_event_dispatcher.h',
        'browser/extensions/api/sockets_udp/udp_socket_event_dispatcher.cc',
        'browser/extensions/api/sockets_udp/sockets_udp_api.cc',
        'browser/extensions/api/sockets_udp/sockets_udp_api.h',
        'browser/extensions/api/spellcheck/spellcheck_api.cc',
        'browser/extensions/api/spellcheck/spellcheck_api.h',
        'browser/extensions/api/storage/leveldb_settings_storage_factory.cc',
        'browser/extensions/api/storage/leveldb_settings_storage_factory.h',
        'browser/extensions/api/storage/managed_value_store_cache.cc',
        'browser/extensions/api/storage/managed_value_store_cache.h',
        'browser/extensions/api/storage/policy_value_store.cc',
        'browser/extensions/api/storage/policy_value_store.h',
        'browser/extensions/api/storage/setting_sync_data.cc',
        'browser/extensions/api/storage/setting_sync_data.h',
        'browser/extensions/api/storage/settings_backend.cc',
        'browser/extensions/api/storage/settings_backend.h',
        'browser/extensions/api/storage/settings_frontend.cc',
        'browser/extensions/api/storage/settings_frontend.h',
        'browser/extensions/api/storage/settings_namespace.cc',
        'browser/extensions/api/storage/settings_namespace.h',
        'browser/extensions/api/storage/settings_observer.h',
        'browser/extensions/api/storage/settings_storage_factory.h',
        'browser/extensions/api/storage/settings_storage_quota_enforcer.cc',
        'browser/extensions/api/storage/settings_storage_quota_enforcer.h',
        'browser/extensions/api/storage/settings_sync_processor.cc',
        'browser/extensions/api/storage/settings_sync_processor.h',
        'browser/extensions/api/storage/settings_sync_util.cc',
        'browser/extensions/api/storage/settings_sync_util.h',
        'browser/extensions/api/storage/storage_api.cc',
        'browser/extensions/api/storage/storage_api.h',
        'browser/extensions/api/storage/sync_or_local_value_store_cache.cc',
        'browser/extensions/api/storage/sync_or_local_value_store_cache.h',
        'browser/extensions/api/storage/syncable_settings_storage.cc',
        'browser/extensions/api/storage/syncable_settings_storage.h',
        'browser/extensions/api/storage/value_store_cache.cc',
        'browser/extensions/api/storage/value_store_cache.h',
        'browser/extensions/api/storage/weak_unlimited_settings_storage.cc',
        'browser/extensions/api/storage/weak_unlimited_settings_storage.h',
        'browser/extensions/api/streams_private/streams_private_api.cc',
        'browser/extensions/api/streams_private/streams_private_api.h',
        'browser/extensions/api/sync_file_system/extension_sync_event_observer_factory.cc',
        'browser/extensions/api/sync_file_system/extension_sync_event_observer_factory.h',
        'browser/extensions/api/sync_file_system/extension_sync_event_observer.cc',
        'browser/extensions/api/sync_file_system/extension_sync_event_observer.h',
        'browser/extensions/api/sync_file_system/sync_file_system_api.cc',
        'browser/extensions/api/sync_file_system/sync_file_system_api.h',
        'browser/extensions/api/sync_file_system/sync_file_system_api_helpers.cc',
        'browser/extensions/api/sync_file_system/sync_file_system_api_helpers.h',
        'browser/extensions/api/system_cpu/cpu_info_provider.cc',
        'browser/extensions/api/system_cpu/cpu_info_provider.h',
        'browser/extensions/api/system_cpu/system_cpu_api.cc',
        'browser/extensions/api/system_cpu/system_cpu_api.h',
        'browser/extensions/api/system_display/display_info_provider.cc',
        'browser/extensions/api/system_display/display_info_provider.h',
        'browser/extensions/api/system_display/display_info_provider_aura.cc',
        'browser/extensions/api/system_display/display_info_provider_chromeos.cc',
        'browser/extensions/api/system_display/display_info_provider_gtk.cc',
        'browser/extensions/api/system_display/display_info_provider_mac.cc',
        'browser/extensions/api/system_display/display_info_provider_win.cc',
        'browser/extensions/api/system_display/system_display_api.cc',
        'browser/extensions/api/system_display/system_display_api.h',
        'browser/extensions/api/system_indicator/system_indicator_api.h',
        'browser/extensions/api/system_indicator/system_indicator_manager.cc',
        'browser/extensions/api/system_indicator/system_indicator_manager.h',
        'browser/extensions/api/system_indicator/system_indicator_manager_factory.cc',
        'browser/extensions/api/system_indicator/system_indicator_manager_factory.h',
        'browser/extensions/api/system_info/system_info_api.cc',
        'browser/extensions/api/system_info/system_info_api.h',
        'browser/extensions/api/system_info/system_info_provider.cc',
        'browser/extensions/api/system_info/system_info_provider.h',
        'browser/extensions/api/system_memory/memory_info_provider.cc',
        'browser/extensions/api/system_memory/memory_info_provider.h',
        'browser/extensions/api/system_memory/system_memory_api.cc',
        'browser/extensions/api/system_memory/system_memory_api.h',
        'browser/extensions/api/system_private/system_private_api.cc',
        'browser/extensions/api/system_private/system_private_api.h',
        'browser/extensions/api/system_storage/storage_info_provider.cc',
        'browser/extensions/api/system_storage/storage_info_provider.h',
        'browser/extensions/api/system_storage/system_storage_api.cc',
        'browser/extensions/api/system_storage/system_storage_api.h',
        'browser/extensions/api/tab_capture/tab_capture_api.cc',
        'browser/extensions/api/tab_capture/tab_capture_api.h',
        'browser/extensions/api/tab_capture/tab_capture_registry.cc',
        'browser/extensions/api/tab_capture/tab_capture_registry.h',
        'browser/extensions/api/tabs/tabs_api.cc',
        'browser/extensions/api/tabs/tabs_api.h',
        'browser/extensions/api/tabs/tabs_windows_api.cc',
        'browser/extensions/api/tabs/tabs_windows_api.h',
        'browser/extensions/api/tabs/tabs_constants.cc',
        'browser/extensions/api/tabs/tabs_constants.h',
        'browser/extensions/api/tabs/tabs_event_router.cc',
        'browser/extensions/api/tabs/tabs_event_router.h',
        'browser/extensions/api/tabs/windows_event_router.cc',
        'browser/extensions/api/tabs/windows_event_router.h',
        'browser/extensions/api/tabs/windows_util.cc',
        'browser/extensions/api/tabs/windows_util.h',
        'browser/extensions/api/test/test_api.cc',
        'browser/extensions/api/test/test_api.h',
        'browser/extensions/api/top_sites/top_sites_api.cc',
        'browser/extensions/api/top_sites/top_sites_api.h',
        'browser/extensions/api/usb/usb_api.cc',
        'browser/extensions/api/usb/usb_api.h',
        'browser/extensions/api/usb/usb_device_resource.cc',
        'browser/extensions/api/usb/usb_device_resource.h',
        'browser/extensions/api/web_navigation/frame_navigation_state.cc',
        'browser/extensions/api/web_navigation/frame_navigation_state.h',
        'browser/extensions/api/web_navigation/web_navigation_api.cc',
        'browser/extensions/api/web_navigation/web_navigation_api.h',
        'browser/extensions/api/web_navigation/web_navigation_api_constants.cc',
        'browser/extensions/api/web_navigation/web_navigation_api_constants.h',
        'browser/extensions/api/web_navigation/web_navigation_api_helpers.cc',
        'browser/extensions/api/web_navigation/web_navigation_api_helpers.h',
        'browser/extensions/api/web_request/form_data_parser.cc',
        'browser/extensions/api/web_request/form_data_parser.h',
        'browser/extensions/api/web_request/upload_data_presenter.cc',
        'browser/extensions/api/web_request/upload_data_presenter.h',
        'browser/extensions/api/web_request/web_request_api.cc',
        'browser/extensions/api/web_request/web_request_api.h',
        'browser/extensions/api/web_request/web_request_api_constants.cc',
        'browser/extensions/api/web_request/web_request_api_constants.h',
        'browser/extensions/api/web_request/web_request_api_helpers.cc',
        'browser/extensions/api/web_request/web_request_api_helpers.h',
        'browser/extensions/api/web_request/web_request_permissions.cc',
        'browser/extensions/api/web_request/web_request_permissions.h',
        'browser/extensions/api/web_request/web_request_time_tracker.cc',
        'browser/extensions/api/web_request/web_request_time_tracker.h',
        'browser/extensions/api/webstore_private/webstore_private_api.cc',
        'browser/extensions/api/webstore_private/webstore_private_api.h',
        'browser/extensions/api/webview/webview_api.cc',
        'browser/extensions/api/webview/webview_api.h',
        'browser/extensions/app_icon_loader.h',
        'browser/extensions/app_icon_loader_impl.cc',
        'browser/extensions/app_icon_loader_impl.h',
        'browser/extensions/app_sync_bundle.cc',
        'browser/extensions/app_sync_bundle.h',
        'browser/extensions/app_sync_data.cc',
        'browser/extensions/app_sync_data.h',
        'browser/extensions/blacklist.cc',
        'browser/extensions/blacklist.h',
        'browser/extensions/browser_action_test_util.h',
        'browser/extensions/browser_extension_window_controller.cc',
        'browser/extensions/browser_extension_window_controller.h',
        'browser/extensions/browser_permissions_policy_delegate.cc',
        'browser/extensions/browser_permissions_policy_delegate.h',
        'browser/extensions/bundle_installer.cc',
        'browser/extensions/bundle_installer.h',
        'browser/extensions/component_loader.cc',
        'browser/extensions/component_loader.h',
        'browser/extensions/context_menu_matcher.cc',
        'browser/extensions/context_menu_matcher.h',
        'browser/extensions/convert_user_script.cc',
        'browser/extensions/convert_user_script.h',
        'browser/extensions/convert_web_app.cc',
        'browser/extensions/convert_web_app.h',
        'browser/extensions/crx_installer.cc',
        'browser/extensions/crx_installer.h',
        'browser/extensions/crx_installer_error.h',
        'browser/extensions/data_deleter.cc',
        'browser/extensions/data_deleter.h',
        'browser/extensions/default_apps.cc',
        'browser/extensions/default_apps.h',
        'browser/extensions/devtools_util.h',
        'browser/extensions/devtools_util.cc',
        'browser/extensions/error_console/error_console.cc',
        'browser/extensions/error_console/error_console.h',
        'browser/extensions/event_listener_map.cc',
        'browser/extensions/event_listener_map.h',
        'browser/extensions/event_names.cc',
        'browser/extensions/event_names.h',
        'browser/extensions/event_router.cc',
        'browser/extensions/event_router.h',
        'browser/extensions/event_router_forwarder.cc',
        'browser/extensions/event_router_forwarder.h',
        'browser/extensions/extension_action.cc',
        'browser/extensions/extension_action.h',
        'browser/extensions/extension_action_icon_factory.cc',
        'browser/extensions/extension_action_icon_factory.h',
        'browser/extensions/extension_action_manager.cc',
        'browser/extensions/extension_action_manager.h',
        'browser/extensions/extension_context_menu_model.cc',
        'browser/extensions/extension_context_menu_model.h',
        'browser/extensions/extension_creator.cc',
        'browser/extensions/extension_creator.h',
        'browser/extensions/extension_creator_filter.cc',
        'browser/extensions/extension_creator_filter.h',
        'browser/extensions/extension_disabled_ui.cc',
        'browser/extensions/extension_disabled_ui.h',
        'browser/extensions/extension_error_reporter.cc',
        'browser/extensions/extension_error_reporter.h',
        'browser/extensions/extension_error_ui.cc',
        'browser/extensions/extension_error_ui.h',
        'browser/extensions/extension_error_ui_default.cc',
        'browser/extensions/extension_error_ui_default.h',
        'browser/extensions/extension_function.cc',
        'browser/extensions/extension_function.h',
        'browser/extensions/extension_function_dispatcher.cc',
        'browser/extensions/extension_function_dispatcher.h',
        'browser/extensions/extension_function_registry.cc',
        'browser/extensions/extension_function_registry.h',
        'browser/extensions/extension_function_util.cc',
        'browser/extensions/extension_function_util.h',
        'browser/extensions/extension_host.cc',
        'browser/extensions/extension_host.h',
        'browser/extensions/extension_host_mac.h',
        'browser/extensions/extension_host_mac.mm',
        'browser/extensions/extension_icon_image.cc',
        'browser/extensions/extension_icon_image.h',
        'browser/extensions/extension_icon_manager.cc',
        'browser/extensions/extension_icon_manager.h',
        'browser/extensions/extension_info_map.cc',
        'browser/extensions/extension_info_map.h',
        'browser/extensions/extension_infobar_delegate.cc',
        'browser/extensions/extension_infobar_delegate.h',
        'browser/extensions/extension_install_prompt.cc',
        'browser/extensions/extension_install_prompt.h',
        'browser/extensions/extension_install_ui.cc',
        'browser/extensions/extension_install_ui.h',
        'browser/extensions/extension_installer.cc',
        'browser/extensions/extension_installer.h',
        'browser/extensions/extension_keybinding_registry.cc',
        'browser/extensions/extension_keybinding_registry.h',
        'browser/extensions/extension_pref_store.cc',
        'browser/extensions/extension_pref_store.h',
        'browser/extensions/extension_pref_value_map.cc',
        'browser/extensions/extension_pref_value_map.h',
        'browser/extensions/extension_pref_value_map_factory.cc',
        'browser/extensions/extension_pref_value_map_factory.h',
        'browser/extensions/extension_prefs.cc',
        'browser/extensions/extension_prefs.h',
        'browser/extensions/extension_prefs_factory.cc',
        'browser/extensions/extension_prefs_factory.h',
        'browser/extensions/extension_process_manager.cc',
        'browser/extensions/extension_process_manager.h',
        'browser/extensions/extension_protocols.cc',
        'browser/extensions/extension_protocols.h',
        'browser/extensions/extension_renderer_state.cc',
        'browser/extensions/extension_renderer_state.h',
        'browser/extensions/extension_resource_protocols.cc',
        'browser/extensions/extension_resource_protocols.h',
        'browser/extensions/extension_scoped_prefs.h',
        'browser/extensions/extension_service.cc',
        'browser/extensions/extension_service.h',
        'browser/extensions/extension_sorting.cc',
        'browser/extensions/extension_sorting.h',
        'browser/extensions/extension_special_storage_policy.cc',
        'browser/extensions/extension_special_storage_policy.h',
        'browser/extensions/extension_system.cc',
        'browser/extensions/extension_system.h',
        'browser/extensions/extension_sync_bundle.cc',
        'browser/extensions/extension_sync_bundle.h',
        'browser/extensions/extension_system_factory.cc',
        'browser/extensions/extension_system_factory.h',
        'browser/extensions/extension_sync_data.cc',
        'browser/extensions/extension_sync_data.h',
        'browser/extensions/extension_tab_util.cc',
        'browser/extensions/extension_tab_util.h',
        'browser/extensions/extension_toolbar_model.cc',
        'browser/extensions/extension_toolbar_model.h',
        'browser/extensions/extension_uninstall_dialog.cc',
        'browser/extensions/extension_uninstall_dialog.h',
        'browser/extensions/extension_warning_badge_service.cc',
        'browser/extensions/extension_warning_badge_service.h',
        'browser/extensions/extension_warning_service.cc',
        'browser/extensions/extension_warning_service.h',
        'browser/extensions/extension_warning_set.cc',
        'browser/extensions/extension_warning_set.h',
        'browser/extensions/extension_web_ui.cc',
        'browser/extensions/extension_web_ui.h',
        'browser/extensions/extension_web_ui_override_registrar.cc',
        'browser/extensions/extension_web_ui_override_registrar.h',
        'browser/extensions/extension_webkit_preferences.cc',
        'browser/extensions/extension_webkit_preferences.h',
        'browser/extensions/extensions_quota_service.cc',
        'browser/extensions/extensions_quota_service.h',
        'browser/extensions/external_component_loader.cc',
        'browser/extensions/external_component_loader.h',
        'browser/extensions/external_install_ui.cc',
        'browser/extensions/external_install_ui.h',
        'browser/extensions/external_loader.cc',
        'browser/extensions/external_loader.h',
        'browser/extensions/external_policy_loader.cc',
        'browser/extensions/external_policy_loader.h',
        'browser/extensions/external_pref_loader.cc',
        'browser/extensions/external_pref_loader.h',
        'browser/extensions/external_provider_impl.cc',
        'browser/extensions/external_provider_impl.h',
        'browser/extensions/external_provider_interface.h',
        'browser/extensions/external_registry_loader_win.cc',
        'browser/extensions/external_registry_loader_win.h',
        'browser/extensions/image_loader.cc',
        'browser/extensions/image_loader.h',
        'browser/extensions/image_loader_factory.cc',
        'browser/extensions/image_loader_factory.h',
        'browser/extensions/installed_loader.cc',
        'browser/extensions/installed_loader.h',
        'browser/extensions/install_observer.h',
        'browser/extensions/install_tracker.cc',
        'browser/extensions/install_tracker.h',
        'browser/extensions/install_tracker_factory.cc',
        'browser/extensions/install_tracker_factory.h',
        'browser/extensions/lazy_background_task_queue.cc',
        'browser/extensions/lazy_background_task_queue.h',
        'browser/extensions/location_bar_controller.h',
        'browser/extensions/management_policy.cc',
        'browser/extensions/management_policy.h',
        'browser/extensions/menu_manager.cc',
        'browser/extensions/menu_manager.h',
        'browser/extensions/message_handler.cc',
        'browser/extensions/message_handler.h',
        'browser/extensions/navigation_observer.cc',
        'browser/extensions/navigation_observer.h',
        'browser/extensions/pack_extension_job.cc',
        'browser/extensions/pack_extension_job.h',
        'browser/extensions/page_action_controller.cc',
        'browser/extensions/page_action_controller.h',
        'browser/extensions/pending_extension_info.cc',
        'browser/extensions/pending_extension_info.h',
        'browser/extensions/pending_extension_manager.cc',
        'browser/extensions/pending_extension_manager.h',
        'browser/extensions/permissions_updater.cc',
        'browser/extensions/permissions_updater.h',
        'browser/extensions/plugin_manager.cc',
        'browser/extensions/plugin_manager.h',
        'browser/extensions/process_map.cc',
        'browser/extensions/process_map.h',
        'browser/extensions/requirements_checker.cc',
        'browser/extensions/requirements_checker.h',
        'browser/extensions/sandboxed_unpacker.cc',
        'browser/extensions/sandboxed_unpacker.h',
        'browser/extensions/script_badge_controller.cc',
        'browser/extensions/script_badge_controller.h',
        'browser/extensions/script_bubble_controller.cc',
        'browser/extensions/script_bubble_controller.h',
        'browser/extensions/script_executor.cc',
        'browser/extensions/script_executor.h',
        'browser/extensions/standard_management_policy_provider.cc',
        'browser/extensions/standard_management_policy_provider.h',
        'browser/extensions/startup_helper.cc',
        'browser/extensions/startup_helper.h',
        'browser/extensions/state_store.cc',
        'browser/extensions/state_store.h',
        'browser/extensions/suggest_permission_util.h',
        'browser/extensions/suggest_permission_util.cc',
        'browser/extensions/tab_helper.cc',
        'browser/extensions/tab_helper.h',
        'browser/extensions/theme_installed_infobar_delegate.cc',
        'browser/extensions/theme_installed_infobar_delegate.h',
        'browser/extensions/unpacked_installer.cc',
        'browser/extensions/unpacked_installer.h',
        'browser/extensions/update_observer.h',
        'browser/extensions/updater/extension_downloader.cc',
        'browser/extensions/updater/extension_downloader.h',
        'browser/extensions/updater/extension_downloader_delegate.cc',
        'browser/extensions/updater/extension_downloader_delegate.h',
        'browser/extensions/updater/extension_updater.cc',
        'browser/extensions/updater/extension_updater.h',
        'browser/extensions/updater/manifest_fetch_data.cc',
        'browser/extensions/updater/manifest_fetch_data.h',
        'browser/extensions/updater/request_queue.h',
        'browser/extensions/updater/request_queue_impl.h',
        'browser/extensions/updater/safe_manifest_parser.cc',
        'browser/extensions/updater/safe_manifest_parser.h',
        'browser/extensions/user_script_listener.cc',
        'browser/extensions/user_script_listener.h',
        'browser/extensions/user_script_master.cc',
        'browser/extensions/user_script_master.h',
        'browser/extensions/webstore_data_fetcher.cc',
        'browser/extensions/webstore_data_fetcher.h',
        'browser/extensions/webstore_data_fetcher_delegate.h',
        'browser/extensions/webstore_inline_installer.cc',
        'browser/extensions/webstore_inline_installer.h',
        'browser/extensions/webstore_install_helper.cc',
        'browser/extensions/webstore_install_helper.h',
        'browser/extensions/webstore_installer.cc',
        'browser/extensions/webstore_installer.h',
        'browser/extensions/webstore_standalone_installer.cc',
        'browser/extensions/webstore_standalone_installer.h',
        'browser/extensions/webstore_startup_installer.cc',
        'browser/extensions/webstore_startup_installer.h',
        'browser/extensions/window_controller.cc',
        'browser/extensions/window_controller.h',
        'browser/extensions/window_controller_list.cc',
        'browser/extensions/window_controller_list.h',
        'browser/extensions/window_controller_list_observer.h',
      ],
      'conditions': [
        ['chromeos==1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../chromeos/ime/input_method.gyp:gencode',
            '../third_party/libevent/libevent.gyp:libevent',
            'contacts_proto',
          ],
          'sources!': [
            'browser/extensions/api/audio/audio_service.cc',
            'browser/extensions/api/diagnostics/diagnostics_api_nonchromeos.cc',
            'browser/extensions/api/feedback_private/feedback_service_nonchromeos.cc',
            'browser/extensions/api/image_writer_private/operation_linux.cc',
            'browser/extensions/api/log_private/log_private_api_nonchromeos.cc',
            'browser/extensions/api/networking_private/networking_private_api_nonchromeos.cc',
            'browser/extensions/api/system_display/display_info_provider_aura.cc',
            'browser/extensions/default_apps.cc',
            'browser/extensions/default_apps.h',
          ],
          'sources': [
            'browser/extensions/api/enterprise_platform_keys_private/enterprise_platform_keys_private_api.cc',
            'browser/extensions/api/enterprise_platform_keys_private/enterprise_platform_keys_private_api.h',
            'browser/extensions/api/input_ime/input_ime_api.cc',
            'browser/extensions/api/input_ime/input_ime_api.h',
            'browser/extensions/api/log_private/log_private_api_chromeos.cc',
            'browser/extensions/api/rtc_private/rtc_private_api.cc',
            'browser/extensions/api/rtc_private/rtc_private_api.h',
            'browser/extensions/api/terminal/terminal_extension_helper.cc',
            'browser/extensions/api/terminal/terminal_extension_helper.h',
            'browser/extensions/api/terminal/terminal_private_api.cc',
            'browser/extensions/api/terminal/terminal_private_api.h',
          ],
        }],
        ['use_ash==1', {
          'sources': [
            'browser/extensions/api/tabs/ash_panel_contents.cc',
            'browser/extensions/api/tabs/ash_panel_contents.h',
          ],
        }],
        ['enable_extensions==0', {
          'sources/': [
            # Handle files in browser/extensions/api. Exclude everything by default, white list
            # files if they are needed for linking.
            # TODO: The re-includes should go away or shrink as extensions are refactored to be
            # less intertwined in the main codebase.
            ['exclude', '^browser/extensions/api/'],
            ['exclude', '^browser/extensions/.*_api\.cc$'],
            ['include', '^browser/extensions/api/activity_log_private/activity_log_private_api.cc'],
            ['include', '^browser/extensions/api/activity_log_private/activity_log_private_api.h'],
            ['include', '^browser/extensions/api/content_settings/content_settings_api_constants.cc'],
            ['include', '^browser/extensions/api/content_settings/content_settings_helpers.cc'],
            ['include', '^browser/extensions/api/content_settings/content_settings_store.cc'],
            ['include', '^browser/extensions/api/declarative/initializing_rules_registry.cc'],
            ['include', '^browser/extensions/api/declarative/rules_registry_service.cc'],
            ['include', '^browser/extensions/api/declarative/rules_registry_with_cache.cc'],
            ['include', '^browser/extensions/api/declarative/substring_set_matcher.cc'],
            ['include', '^browser/extensions/api/declarative/url_matcher.cc'],
            ['include', '^browser/extensions/api/declarative_webrequest/request_stage.cc'],
            ['include', '^browser/extensions/api/declarative_webrequest/webrequest_action.cc'],
            ['include', '^browser/extensions/api/declarative_webrequest/webrequest_condition.cc'],
            ['include', '^browser/extensions/api/declarative_webrequest/webrequest_condition_attribute.cc'],
            ['include', '^browser/extensions/api/declarative_webrequest/webrequest_constants.cc'],
            ['include', '^browser/extensions/api/declarative_webrequest/webrequest_rules_registry.cc'],
            ['include', '^browser/extensions/api/extension_action/extension_action_api.cc'],
            ['include', '^browser/extensions/api/extension_action/extension_page_actions_api_constants.cc'],
            ['include', '^browser/extensions/api/messaging/extension_message_port.cc'],
            ['include', '^browser/extensions/api/messaging/message_service.cc'],
            ['include', '^browser/extensions/api/module/module.cc'],
            ['include', '^browser/extensions/api/omnibox/omnibox_api.cc'],
            ['include', '^browser/extensions/api/preference/preference_api.cc'],
            ['include', '^browser/extensions/api/proxy/proxy_api.cc'],
            ['include', '^browser/extensions/api/proxy/proxy_api_constants.cc'],
            ['include', '^browser/extensions/api/runtime/runtime_api.cc'],
            ['include', '^browser/extensions/api/storage/.*\.cc'],
            ['include', '^browser/extensions/api/tabs/tabs_constants.cc'],
            ['include', '^browser/extensions/api/web_navigation/frame_navigation_state.cc'],
            ['include', '^browser/extensions/api/web_navigation/web_navigation_api.cc'],
            ['include', '^browser/extensions/api/web_navigation/web_navigation_api_constants.cc'],
            ['include', '^browser/extensions/api/web_navigation/web_navigation_api_helpers.cc'],
            ['include', '^browser/extensions/api/web_request/form_data_parser.cc'],
            ['include', '^browser/extensions/api/web_request/upload_data_presenter.cc'],
            ['include', '^browser/extensions/api/web_request/web_request_api.cc'],
            ['include', '^browser/extensions/api/web_request/web_request_api_constants.cc'],
            ['include', '^browser/extensions/api/web_request/web_request_api_helpers.cc'],
            ['include', '^browser/extensions/api/web_request/web_request_permissions.cc'],
            ['include', '^browser/extensions/api/web_request/web_request_time_tracker.cc'],
          ],
          'dependencies!': [
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
            '../third_party/libusb/libusb.gyp:libusb'
          ],
        }],
        ['use_aura==1', {
          'dependencies': [
            '../ui/keyboard/keyboard.gyp:keyboard',
            '../ui/keyboard/keyboard.gyp:keyboard_resources',
          ],
        }],
        ['OS=="linux" and use_aura==1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:fontconfig',
            '../build/linux/system.gyp:x11',
            '../dbus/dbus.gyp:dbus',
          ],
        }],
        ['safe_browsing==1', {
          'defines': [
            'FULL_SAFE_BROWSING',
          ],
        }],
        ['safe_browsing==2', {
          'defines': [
            'MOBILE_SAFE_BROWSING',
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:gconf',
            '../build/linux/system.gyp:gtk',
            '../build/linux/system.gyp:gtkprint',
            '../build/linux/system.gyp:ssl',
            '../build/linux/system.gyp:x11',
            '../dbus/dbus.gyp:dbus',
            '../third_party/undoview/undoview.gyp:undoview',
          ],
        }],
        ['configuration_policy==1', {
          'dependencies': [
            'app/policy/cloud_policy_codegen.gyp:policy',
          ],
        }, {  # configuration_policy==0
          'sources!': [
            'browser/extensions/api/storage/managed_value_store_cache.cc',
            'browser/extensions/api/storage/managed_value_store_cache.h',
            'browser/extensions/api/storage/policy_value_store.cc',
            'browser/extensions/api/storage/policy_value_store.h',
          ],
        }],
        ['OS=="win"', {
          'dependencies': [
            'launcher_support',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
          ],
          'sources!': [
            'browser/extensions/api/system_display/display_info_provider_aura.cc',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
        }, {  # 'OS!="win"
          'conditions': [
            ['OS=="linux" and toolkit_views==1',{
              'include_dirs': [
                '<(INTERMEDIATE_DIR)',
                '<(INTERMEDIATE_DIR)/chrome',
              ],
              'sources/': [
                # Other excluded stuff.
                ['exclude', '^browser/extensions/extension_host_mac.h'],
                ['exclude', '^browser/extensions/extension_host_mac.mm'],
                ['exclude', '^browser/extensions/external_registry_loader_win.cc'],
                ['exclude', '^browser/extensions/external_registry_loader_win.h'],
              ],
            }],
            ['chromeos==1',{
              'dependencies': [
                '../dbus/dbus.gyp:dbus',
                '../third_party/protobuf/protobuf.gyp:protobuf_lite',
                '../third_party/protobuf/protobuf.gyp:protoc#host',
              ],
            }],
          ],
        }],
        ['use_openssl==1', {
          'sources!': [
            # networking_private_crypto.cc uses NSS functions.
            'browser/extensions/api/networking_private/networking_private_crypto.cc',
          ],
        }],
        ['OS=="android"', {
          'sources': [
            'browser/extensions/extension_error_ui_android.cc',
            'browser/extensions/extension_error_ui_android.h',
            'browser/extensions/extension_tab_util_android.cc',
          ],
          'sources!': [
            'browser/apps/shortcut_manager.cc',
            'browser/apps/shortcut_manager_factory.cc',
            'browser/extensions/activity_log/uma_policy.cc',
            'browser/extensions/api/declarative/rules_registry_with_cache.cc',
            'browser/extensions/api/processes/processes_api_constants.cc',
            'browser/extensions/api/web_navigation/frame_navigation_state.cc',
            'browser/extensions/api/web_navigation/web_navigation_api.cc',
            'browser/extensions/api/web_navigation/web_navigation_api_constants.cc',
            'browser/extensions/app_icon_loader_impl.cc',
            'browser/extensions/browser_extension_window_controller.cc',
            'browser/extensions/context_menu_matcher.cc',
            'browser/extensions/extension_context_menu_model.cc',
            'browser/extensions/extension_error_ui_default.cc',
            'browser/extensions/extension_error_ui_default.h',
            'browser/extensions/extension_function_util.cc',
            'browser/extensions/extension_infobar_delegate.cc',
            'browser/extensions/extension_install_ui.cc',
            'browser/extensions/extension_tab_util.cc',
            'browser/extensions/extension_uninstall_dialog.cc',
            'browser/extensions/theme_installed_infobar_delegate.cc',
            'browser/extensions/webstore_startup_installer.cc',
            'browser/extensions/window_controller.cc',
            'browser/extensions/window_controller_list.cc',
          ],
        }],
        ['chrome_multiple_dll!=1', {
          'dependencies': [
            '../webkit/support/webkit_support.gyp:glue',
          ],
        }],
        ['use_brlapi==1', {
          'sources!': [
            'browser/extensions/api/braille_display_private/braille_controller_stub.cc',
          ],
          'dependencies' : [
            '../build/linux/system.gyp:libbrlapi',
          ],
          'defines': [
            'USE_BRLAPI',
          ],
        }, {  # use_brlapi==0
          'sources!': [
            'browser/extensions/api/braille_display_private/braille_controller_brlapi.cc',
            'browser/extensions/api/braille_display_private/brlapi_connection.cc',
          ],
        }],
      ],
    },
  ],
  'conditions': [
    ['chromeos==1', {
      'targets': [
        {
          # Protobuf compiler / generator for contacts-related protocol buffers.
          'target_name': 'contacts_proto',
          'type': 'static_library',
          'sources': [ 'browser/chromeos/contacts/contact.proto' ],
          'variables': {
            'proto_in_dir': 'browser/chromeos/contacts',
            'proto_out_dir': 'chrome/browser/chromeos/contacts',
          },
          'includes': [ '../build/protoc.gypi' ]
        },
      ],
    },],  # 'chromeos=1'
  ],  # 'conditions'
}
