// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHROMEOS_VIEW_IDS_H_
#define CHROME_BROWSER_CHROMEOS_VIEW_IDS_H_

#include "chrome/browser/ui/view_ids.h"

// View ID used in ChromeOS.
enum ChromeOSViewIds {
  // Start with the offset that is big enough to avoid possible
  // collision.
  VIEW_ID_STATUS_AREA = VIEW_ID_PREDEFINED_COUNT + 10000,
  VIEW_ID_LAYOUT_MODE_BUTTON,

  VIEW_ID_STATUS_BUTTON_ACCESSIBILITY,
  VIEW_ID_STATUS_BUTTON_CAPS_LOCK,
  VIEW_ID_STATUS_BUTTON_CLOCK,
  VIEW_ID_STATUS_BUTTON_INPUT_METHOD,
  VIEW_ID_STATUS_BUTTON_MEMORY,
  VIEW_ID_STATUS_BUTTON_NETWORK_MENU,
  VIEW_ID_STATUS_BUTTON_POWER,
  VIEW_ID_STATUS_BUTTON_VOLUME,
};

#endif  // CHROME_BROWSER_CHROMEOS_VIEW_IDS_H_
