/* FLASK */

/* 
 * Global definitions that are included at the beginning
 * of every file using the -include directive.
 *
 * These definitions are used to permit the same
 * source code to be used to build both the security
 * server component of the kernel and the checkpolicy
 * program.
 */

#ifndef __SS_GLOBAL_H
#define __SS_GLOBAL_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <byteswap.h>
#include <endian.h>

typedef unsigned int security_id_t;
#define SECSID_NULL 0
#define SELINUX_MAGIC 0xf97cff8c 

#define selinux_enforcing 1

#include "flask.h"
#include "security.h"
#include "avc_ss.h"
#include "av_permissions.h"

#define NIPQUAD(addr) \
	((unsigned char *)&addr)[0], \
	((unsigned char *)&addr)[1], \
	((unsigned char *)&addr)[2], \
	((unsigned char *)&addr)[3]

#if __BYTE_ORDER == __LITTLE_ENDIAN
#define cpu_to_le32(x) (x)
#define le32_to_cpu(x) (x)
#define cpu_to_le64(x) (x)
#define le64_to_cpu(x) (x)
#else
#define cpu_to_le32(x) bswap_32(x)
#define le32_to_cpu(x) bswap_32(x)
#define cpu_to_le64(x) bswap_64(x)
#define le64_to_cpu(x) bswap_64(x)
#endif

#define wmb() 

#define kmalloc(size, flags) malloc(size)
#define kfree(ptr) free(ptr)
#define vmalloc(size) malloc(size)
#define vfree(ptr) free(ptr)

#define printk printf

typedef unsigned int spinlock_t;
#define spin_lock_init(x) *(x) = 0
#define spin_lock_irq(x)
#define spin_unlock_irq(x)

typedef unsigned int rwlock_t;
#define read_lock(x) *(x) = 1
#define read_unlock(x)
#define write_lock_irq(x)
#define write_unlock_irq(x)
#define RW_LOCK_UNLOCKED 0

#define DECLARE_MUTEX(x) unsigned int x
#define down(x) *(x) = 1
#define up(x) 

#define BUG_ON(x) do { if (x) printf("Badness in %s at %s:%d\n", __FUNCTION__, __FILE__, __LINE__); } while (0)

#define BUG() do { printf("Badness in %s at %s:%d\n", __FUNCTION__, __FILE__, __LINE__); } while (0)

static inline void selinux_complete_init(void) {}

#endif /* __SS_GLOBAL_H */
