#ifndef H_CDW_FS_BROWSER
#define H_CDW_FS_BROWSER

#include <stddef.h> /* size_t */
#include <ncursesw/ncurses.h>

#include "cdw_list_display.h"
#include "cdw_file.h"

typedef struct  {
	/* *** public *** */

	CDW_LIST_DISPLAY *display;

	/* *** private *** */

} cdw_fs_browser_t;


cdw_fs_browser_t *cdw_fs_browser_new(WINDOW *parent, const char *initial_fullpath);
void              cdw_fs_browser_delete(cdw_fs_browser_t **browser);

int cdw_fs_browser_driver(cdw_fs_browser_t *browser);

/* TODO:
    - remove cdw_fs_browser_browse_to(),
    - change cdw_fs_browser_browse_to_file() to ...browse_to():
      function that browses to given file
    - change cdw_fs_browser_browse_into_dir() to ...browse_into():
      function that attempts to browse into given path as if it was a dir */
int cdw_fs_browser_browse_to(cdw_fs_browser_t *browser, const char *fullpath);
int cdw_fs_browser_browse_into_dir(cdw_fs_browser_t *browser, const char *dirpath);
int cdw_fs_browser_browse_to_file(cdw_fs_browser_t *browser, const char *fullpath);


cdw_file_t    *cdw_fs_browser_get_current_file(cdw_fs_browser_t *browser);
char          *cdw_fs_browser_get_current_dirpath(cdw_fs_browser_t *browser);
char          *cdw_fs_browser_get_current_printable_dirpath(cdw_fs_browser_t *browser);
const char    *cdw_fs_browser_get_current_fullpath(cdw_fs_browser_t *browser);

bool cdw_fs_browser_is_navigation_key(int key);

void cdw_fs_browser_wrapper(void);

#endif /* #ifndef H_CDW_FS_BROWSER */

