#ifndef __CDW_WIDGETS_H
#define __CDW_WIDGETS_H

#include <ncursesw/ncurses.h>


/**
 * Type of simple dialog window. This value defines background color
 * and number and types of buttons.
 */
enum dialog_type {
	DIALOG_OK = 0,
	DIALOG_OK_CANCEL = 3,
	DIALOG_YES_NO_CANCEL = 4
};


/**
 * Value returned by dialogbox() function - button selected
 * by user in dialog window.
 */
enum dialog_button {
	BUTTON_OK = 0,
	BUTTON_YES = 1,
	BUTTON_NO = 2,
	BUTTON_CANCEL = 3
};

int inbox(WINDOW *window, char *init, bool hash);
int input_passwd(char *title, char *label, char *prop);
void nice_box(WINDOW *window, char *top_string, char *bottom_string);
int dialogbox(char *title, char *message, int type);
int input_box(char *title, char *label, char *prop, int mode);


void put_ckbox(WINDOW *win, int y, int x);

#endif /* ifndef __CDW_WIDGETS_H */
