#ifndef __CDW_UI_H
#define __CDW_UI_H

#include <ncurses.h>
#include <dirent.h>

enum menu_items {
	UI_MENU_ADD_FILES = 0,
	UI_MENU_DELETE_FILES,
	UI_MENU_CREATE_IMAGE,
	UI_MENU_COPY_DATA_DISC_TO_IMAGE,
	UI_MENU_RIP_AUDIO_DISC,
	UI_MENU_WRITE_TO_DISC,
	UI_MENU_BLANK_CDRW,
	UI_MENU_EDIT_OPTIONS,
	UI_MENU_EXIT_CDW
};


typedef struct file_item {
	char filename[255];
	int type;
	int size;
} fileitem;

int fill_filelist(char *dir, fileitem **filei, struct dirent **eps, int n);

void fill_info(void);

void put_addwin(int width, int height, int y, int x);

void mainform_init(void);
int mainform_clean(void);

void main_win_refresh(bool real);
void main_win_refresh_part(int nlines, int ncols, int begin_y, int begin_x);

int conditional_volume_label_dialog(void);

int select_window(bool real);
int blank_method_selector(void);
int cdw_title_init(void);
void scroll_addlist(WINDOW *addwinlist, int menupos, fileitem *filei, int maxfiles);
void cdmenu_clean(void);
void menu_clean(void);
void title_clean(void);
int cdw_curses_init(void);

void delete_files(void);
void size_selector(void);

bool open_target_image_file(int *filedes);

#endif /* _CDW_UI_H */
