/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ncursesw/ncurses.h>
#include <locale.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <libintl.h>
#include <nl_types.h>
#include "options.h"
#include "config.h"
#include "gettext.h"

#ifdef GTK_GUI
#include <gtk/gtk.h>
#include <glib.h>
#include "gtkgui.h"
#include "gtk_thread.h"
#include "gtk_cddb.h"

char homedir[256];
struct conf config;
double size_gtk;
GtkWidget *size_msg, *scroll_win, *filelist, *fileselect, *toolbar, *radio_frame, *radio_vbox, *info[3];
static gint rowindex=-1;
gchar *selectedFile=NULL;

/*** LABELS ***/
GtkWidget *label_SCSI, *label_speed, *label_image, *label_log, *label_cdrom, *label_cdrw, *label_volid;
GtkWidget *label_mnt, *label_host, *label_user, *label_audio, *label_sqlite_file, *label_bpc, *label_bps, *label_bootimg;
/*** CHECK BUTTONS ***/
GtkWidget *check_image, *check_blank, *check_eject, *check_dao, *check_joliet, *check_rr, *check_rrattr;
GtkWidget *check_dummy, *check_log, *check_vol, *check_pad, *check_multi, *check_burnproof;
GtkWidget *check_autodic, *check_stereo, *check_sound, *check_high, *check_encode;
/*** RADIO BUTTONS ***/
GtkWidget *radio_ogg, *radio_mp3, *size_entry;

/*** FUNCTION DECLARATIONS ***/

int select_window_gtk(bool real);
void fill_info_gtk();

/*****************************/


gboolean gtk_input(char *title, char *msg, char *text, int size, gboolean is_password)
{
    GtkWidget *dialog, *label, *entry;
    gint result;

    dialog = gtk_dialog_new_with_buttons(title, GTK_WINDOW(window1), GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);
    gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
    label = gtk_label_new(msg);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
    entry = gtk_entry_new_with_max_length(size);
    if (is_password)
	gtk_entry_set_visibility(GTK_ENTRY(entry), FALSE);
    gtk_entry_set_text(GTK_ENTRY(entry), text);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), entry, TRUE, TRUE, 0);
    gtk_widget_show(label);
    gtk_widget_show(entry);
    result=gtk_dialog_run(GTK_DIALOG(dialog));
    switch (result) {
	case GTK_RESPONSE_ACCEPT:
	    sprintf(text, "%s", gtk_entry_get_text(GTK_ENTRY(entry)));
	    gtk_widget_destroy(dialog);
	    return TRUE;
	    break;
	default:
	    gtk_widget_destroy(dialog);
	    return FALSE;
	    break;
    }
}

gboolean gtk_message(char *msg)
{
    GtkWidget *dialog;
    gint result;

    dialog = gtk_message_dialog_new(GTK_WINDOW(window1), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, msg);
    gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
    result=gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
    switch (result) {
	case GTK_RESPONSE_YES:
	    return TRUE;
	    break;
	default:
	    return FALSE;
	    break;
    }
}

gboolean gtk_error_message(char *msg)
{
    GtkWidget *dialog;
    gint result;

    dialog = gtk_message_dialog_new(GTK_WINDOW(window1), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK, msg);
    gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
    result=gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
    return TRUE;
}

gboolean help_win_gtk(GtkWidget *widget, gpointer user_data)
{
    GtkWidget *dialog, *version_label, *image, *frame, *vbox, *scroll, *view;
    gint result, i;
    GtkTextBuffer *buffer;
    char imagefile[255], title[20];

    dialog = gtk_dialog_new_with_buttons(_("About"), GTK_WINDOW(window1), GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL);
    gtk_window_set_default_size (GTK_WINDOW(dialog), 400, 300);
    //gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
    frame=gtk_frame_new(NULL);
    vbox=gtk_vbox_new(FALSE, 2);
    sprintf(imagefile, "%s/pixmaps/about.png", CDWDIR);
    image=gtk_image_new_from_file(imagefile);
    sprintf(title, "%s: %s", _("Version"), VERSION);
    version_label=gtk_label_new(title);
    scroll=gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    buffer = gtk_text_buffer_new(NULL);
    gtk_text_buffer_insert_at_cursor(buffer, "Copyright (c) 2002-2004 Balazs Varkonyi\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  Authors:\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  * Balazs Varkonyi <vbali@linuxforge.hu>\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  * Csaba Feher <linuxfan@nrg.hu>\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  Special thanks to:\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  * Laszlo Boszormenyi <gcs@debian.hu>\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  * Sebastian Henschel <cdw@kodeaffe.de>\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  * Marcel Hilzinger <hili@suselinux.hu>\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  * Jesus Espino <jespino@gul.uc3m.es>\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  cdw is free software; you can redistribute it and/or\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "  modify it under the terms of the GNU General Public License\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "\n", -1);
    gtk_text_buffer_insert_at_cursor(buffer, "Homepage: http://cdw.sourceforge.net\n", -1);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), frame, FALSE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(frame), vbox);
    gtk_box_pack_start(GTK_BOX(vbox), image, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), version_label, FALSE, FALSE, 0);
    scroll=gtk_scrolled_window_new(NULL, NULL);
    view=gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_editable(GTK_TEXT_VIEW(view), FALSE);
    gtk_container_add(GTK_CONTAINER(scroll), view);
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), scroll);
    gtk_widget_show_all(GTK_DIALOG(dialog)->vbox);

    gtk_widget_show_all(dialog);
    result=gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
}

void size_toggled(GtkWidget *widget, gpointer user_data)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
	gtk_widget_set_sensitive(size_entry, TRUE);
    else
	gtk_widget_set_sensitive(size_entry, FALSE);
}

void text_dialog(char *title, char *command, char *file)
{
    FILE *logf;
    char *line, *out;
    GtkWidget *dialog, *view, *scroll;
    GtkTextBuffer *buffer;
    gsize *bytes_read, *bytes_written;
    int i;

    dialog = gtk_dialog_new_with_buttons(title, GTK_WINDOW(window1), GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL);
    scroll=gtk_scrolled_window_new(NULL, NULL);
    gtk_window_set_default_size (GTK_WINDOW(dialog), 400, 300);
    buffer = gtk_text_buffer_new(NULL);
    if ( (logf=fopen(file, "r"))!=NULL ) {
	line=(char *)malloc(256);
	while ( (fgets(line, 250, logf)!=NULL) ){
	    gtk_text_buffer_insert_at_cursor(buffer, line, -1);
	}
	fclose(logf);
    }
    view=gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_editable(GTK_TEXT_VIEW(view), FALSE);
    gtk_container_add(GTK_CONTAINER(scroll), view);
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), scroll);
    gtk_widget_show_all(GTK_DIALOG(dialog)->vbox);
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
}

void log_window_gtk(GtkWidget *widget, gpointer user_data)
{
    text_dialog(_("Log window"), "", config.logfile);
}

void show_cd_info_gtk(GtkWidget *widget, gpointer user_data)
{
    char command[255];

    sprintf(command, "%s dev=%s -atip", CDRECORD, config.scsi);
    run_command_gtk(command, _("Load CD info..."), 0, 0, 0, "");
    text_dialog(_("CD info"), "", config.logfile);
}


void volume_id_gtk(GtkWidget *widget, gpointer user_data)
{
    gtk_input(_("Volume ID"), _("Enter volume label:"), config.volumeid, 40, FALSE);
    write_conf();
}

void parameters_gtk(GtkWidget *widget, gpointer user_data)
{
    gtk_input(_("CD record parameters"), _("Enter parameter:"), config.other, 255, FALSE);
    write_conf();
}

gboolean select_size_gtk(GtkWidget *widget, gpointer user_data)
{
    GtkWidget *dialog, *radio[4], *frame, *vbox1;
    gint result, i;
    gchar sizestr[5];

    dialog = gtk_dialog_new_with_buttons(_("CD size"), GTK_WINDOW(window1), GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);
    radio[0]=gtk_radio_button_new_with_label(NULL, "74 Min (650 MB)");
    radio[1]=gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON(radio[0]), "80 Min (700 MB)");
    radio[2]=gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON(radio[0]), "DVD-  (4700 MB)");
    radio[3]=gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON(radio[0]), "User defined:");
    gtk_signal_connect(GTK_OBJECT(radio[3]), "toggled", G_CALLBACK(size_toggled), NULL);
    size_entry=gtk_entry_new();
    frame=gtk_frame_new(_("Select CD size:"));
    vbox1=gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame), vbox1);
    for (i=0; i<4; i++)
	gtk_box_pack_start(GTK_BOX(vbox1), radio[i], FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox1), size_entry, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), frame, FALSE, FALSE, 0);
    gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
    gtk_widget_set_sensitive(size_entry, FALSE);
    switch (config.cdsize) {
	case 657:
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio[0]), TRUE);
	    break;
	case 702:
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio[1]), TRUE);
	    break;
	case 4700:
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio[2]), TRUE);
	    break;
	default:
	    gtk_widget_set_sensitive(size_entry, TRUE);
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio[3]), TRUE);
	    sprintf(sizestr, "%d", config.cdsize);
	    gtk_entry_set_text(GTK_ENTRY(size_entry), sizestr);
	    break;
    }
    gtk_widget_show_all(frame);
    result=gtk_dialog_run(GTK_DIALOG(dialog));
    switch (result) {
	case GTK_RESPONSE_ACCEPT:
	    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio[0])))
		config.cdsize=657;
	    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio[1])))
		config.cdsize=702;
	    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio[2])))
		config.cdsize=4700;
	    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio[3])))
		config.cdsize=atoi(gtk_entry_get_text(GTK_ENTRY(size_entry)));
	    write_conf();
	    gtk_widget_destroy(dialog);
	    select_window_gtk(TRUE);
	    return TRUE;
	    break;
	default:
	    gtk_widget_destroy(dialog);
	    return FALSE;
	    break;
    }
}

void eject_gtk(GtkWidget *widget, gpointer user_data)
{
    eject_tray(config.cdrwdevice);
}


void after_event_gtk(char *message, int adddic){
    if ( strcmp(config.showlog, "1")==0 )
        log_window_gtk(NULL, NULL);
#ifdef HAVE_LIBMYSQLCLIENT
    if ( (strcmp(config.autodic, "1")==0) && (adddic==1) )
	add_to_dic_gtk();
#endif
#ifdef HAVE_LIBSQLITE
    if ( (strcmp(config.autodic, "1")==0) && (adddic==1) )
	add_to_dic_gtk();
#endif
    if ( strcmp(config.eject, "1")==0 ){
        eject_tray(config.cdrwdevice);
    }
}

void browse_store_filename(GtkWidget *widget, gpointer user_data)
{
    const gchar *selected_filename;

    gtk_entry_set_text(GTK_ENTRY(user_data), gtk_file_selection_get_filename(GTK_FILE_SELECTION(fileselect)));
}

void browse_gtk(GtkWidget *widget, gpointer user_data)
{
    fileselect=gtk_file_selection_new(_("Select files"));
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(fileselect), gtk_entry_get_text(GTK_ENTRY(user_data)));
    g_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fileselect)->ok_button), "clicked", G_CALLBACK(browse_store_filename), user_data);
    gtk_dialog_run(GTK_DIALOG(fileselect));
    gtk_widget_destroy(fileselect);
}

GtkWidget *gtk_entry_with_label(char *text, int size, gboolean is_browse, int type, int min, int max)
{
    GtkWidget *label, *entry, *hbox, *button;

    hbox=gtk_hbox_new(FALSE, 0);
    label=gtk_label_new(text);
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    switch (type){
	case 1:
	    entry=gtk_spin_button_new_with_range(min, max, 1);
	    break;
	default:
	    entry=gtk_entry_new_with_max_length(size);
	    if (size<20) {
		gtk_entry_set_width_chars(GTK_ENTRY(entry), size+1);
	    } else {
		if (is_browse)
		    gtk_entry_set_width_chars(GTK_ENTRY(entry), 20);
		else
		    gtk_entry_set_width_chars(GTK_ENTRY(entry), 24);
	    }
	    break;
    }
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE, 0);
    if (is_browse){
	button=gtk_button_new_with_label("...");
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", G_CALLBACK(browse_gtk), entry);
    }
    return hbox;
}

void encode_toggled(GtkWidget *widget, gpointer user_data)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))) {
#ifdef OGGENC
	gtk_widget_set_sensitive(radio_frame, TRUE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_ogg), TRUE);
#endif
#ifdef LAME
	gtk_widget_set_sensitive(radio_frame, TRUE);
	if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_ogg)))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_mp3), TRUE);
#endif
    } else {
	gtk_widget_set_sensitive(radio_frame, FALSE);
    }
}

void image_toggled(GtkWidget *widget, gpointer user_data)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_multi), FALSE);
	gtk_widget_set_sensitive(check_multi, FALSE);
    } else
	gtk_widget_set_sensitive(check_multi, TRUE);
}

void multi_toggled(GtkWidget *widget, gpointer user_data)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_image), FALSE);
	gtk_widget_set_sensitive(check_image, FALSE);
    } else
	gtk_widget_set_sensitive(check_image, TRUE);
}

gboolean options_gtk(GtkWidget *widget, gpointer user_data)
{
    GtkWidget *dialog, *tab_label[2], *entry, *page[2], *tab, *hbox[2], *vbox[4];
    gint i, result;
    GtkBoxChild *gchild;
    gdouble speed;

    dialog = gtk_dialog_new_with_buttons(_("Options"), GTK_WINDOW(window1), GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);
    gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
    page[0] = gtk_frame_new(NULL);
    page[1] = gtk_frame_new(NULL);

    for (i=0; i<2; i++)
	hbox[i]=gtk_hbox_new(FALSE, 5);
    for (i=0; i<4; i++)
	vbox[i]=gtk_vbox_new(FALSE, 0);

    label_SCSI=gtk_entry_with_label(_("SCSI device"), 255, FALSE, 0, 0, 0);
    label_image=gtk_entry_with_label(_("Image file"), 255, TRUE, 0, 0, 0);
    label_log=gtk_entry_with_label(_("Logfile"), 255, TRUE, 0, 0, 0);
    label_cdrom=gtk_entry_with_label(_("CD-ROM device"), 255, TRUE, 0, 0, 0);
    label_cdrw=gtk_entry_with_label(_("CD-RW device"), 255, TRUE, 0, 0, 0);
    label_volid=gtk_entry_with_label(_("Volume ID"), 40, FALSE, 0, 0, 0);
    check_image=gtk_check_button_new_with_label(_("Write CD from image"));
    check_blank=gtk_check_button_new_with_label(_("Blank fast"));
    check_eject=gtk_check_button_new_with_label(_("Eject CD tray when finished"));
    check_dao=gtk_check_button_new_with_label(_("Disk at once"));
    check_joliet=gtk_check_button_new_with_label(_("Joliet information"));
    check_rr=gtk_check_button_new_with_label(_("Rock Ridge"));
    check_rrattr=gtk_check_button_new_with_label(_("Usefull Rock Ridge attributes"));
    check_dummy=gtk_check_button_new_with_label(_("Dummy write"));
    label_speed=gtk_entry_with_label(_("Speed"), 2, FALSE, 1, 1, 99);
    check_log=gtk_check_button_new_with_label(_("Show log after write"));
    check_vol=gtk_check_button_new_with_label(_("Auto show volume edit dialog"));
    check_pad=gtk_check_button_new_with_label(_("Pad"));
    check_multi=gtk_check_button_new_with_label(_("Write in multi-session"));
    check_burnproof=gtk_check_button_new_with_label(_("Burnproof"));
    label_bootimg=gtk_entry_with_label(_("Boot image"), 255, FALSE, 0, 0, 0);
    check_autodic=gtk_check_button_new_with_label(_("Auto disk catalog"));
    check_stereo=gtk_check_button_new_with_label(_("Grab stereo mode"));
    check_sound=gtk_check_button_new_with_label(_("Echo to soundcard"));
    check_high=gtk_check_button_new_with_label(_("High quality"));
    check_encode=gtk_check_button_new_with_label(_("Encode audio:"));
    label_mnt=gtk_entry_with_label(_("CD mountpoint"), 255, TRUE, 0, 0, 0);
    label_host=gtk_entry_with_label(_("MySQL host"), 255, FALSE, 0, 0, 0);
    label_user=gtk_entry_with_label(_("MySQL user"), 20, FALSE, 0, 0, 0);
    label_sqlite_file=gtk_entry_with_label(_("SQLite DB file"), 255, TRUE, 0, 0, 0);
    label_audio=gtk_entry_with_label(_("Audio directory"), 255, TRUE, 0, 0, 0);
    label_bpc=gtk_entry_with_label(_("Bits per channel"), 2, FALSE, 0, 0, 0);
    label_bps=gtk_entry_with_label(_("Bitrate"), 3, FALSE, 0, 0, 0);
    radio_ogg=gtk_radio_button_new_with_label(NULL, _("Encode to Ogg Vorbis"));
    radio_mp3=gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON(radio_ogg), _("Encode to MP3"));
    radio_frame=gtk_frame_new(_("Encode to"));
    radio_vbox=gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(radio_frame), radio_vbox);
    gtk_box_pack_start(GTK_BOX(radio_vbox), radio_ogg, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(radio_vbox), radio_mp3, FALSE, FALSE, 0);
    /*** PAGE1 LEFT_BOX ***/
    gtk_box_pack_start(GTK_BOX(vbox[0]), label_SCSI, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), label_image, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), label_log, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), label_cdrw, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_blank, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_dao, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_rr, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_dummy, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_vol, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_multi, FALSE, FALSE, 0);
    /*** PAGE1 RIGHT_BOX ***/
    gtk_box_pack_start(GTK_BOX(vbox[1]), label_speed, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), check_image, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), label_cdrom, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), label_volid, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), check_eject, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), check_joliet, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), check_rrattr, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), check_log, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), check_pad, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), check_burnproof, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), label_bootimg, FALSE, FALSE, 0);
    /*** PAGE2 LEFT_BOX ***/
    gtk_box_pack_start(GTK_BOX(vbox[2]), label_mnt, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[2]), label_host, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[2]), label_audio, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[2]), check_stereo, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[2]), check_high, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[2]), check_encode, FALSE, FALSE, 0);
    /*** PAGE2 RIGHT_BOX ***/
    gtk_box_pack_start(GTK_BOX(vbox[3]), check_autodic, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[3]), label_user, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[3]), label_sqlite_file, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[3]), label_bpc, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[3]), check_sound, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[3]), label_bps, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[3]), radio_frame, FALSE, FALSE, 0);

    /*** FILL DATA ***/
    gchild=GTK_BOX(label_SCSI)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.scsi);
    gchild=GTK_BOX(label_speed)->children->next->data;
    speed=atoi(config.speed);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(gchild->widget), (float)speed);
    gchild=GTK_BOX(label_image)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.tempdir);
    gchild=GTK_BOX(label_log)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.logfile);
    gchild=GTK_BOX(label_cdrom)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.cdrom);
    gchild=GTK_BOX(label_cdrw)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.cdrwdevice);
    gchild=GTK_BOX(label_volid)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.volumeid);
    gchild=GTK_BOX(label_audio)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.audiodir);
    gchild=GTK_BOX(label_bpc)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.bitsperchn);
    gchild=GTK_BOX(label_bps)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.bitrate);
    gchild=GTK_BOX(label_mnt)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.mountpoint);
    gchild=GTK_BOX(label_bootimg)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.bootimg);
#ifdef HAVE_LIBMYSQLCLIENT
    gchild=GTK_BOX(label_host)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.cdbhost);
    gchild=GTK_BOX(label_user)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.cdbuser);
    gtk_widget_set_sensitive(label_sqlite_file, FALSE);
    gtk_widget_set_sensitive(label_sqlite_file, FALSE);
#else
#ifndef HAVE_LIBSQLITE
    gtk_widget_set_sensitive(label_mnt, FALSE);
    gtk_widget_set_sensitive(check_autodic, FALSE);
    gtk_widget_set_sensitive(label_sqlite_file, FALSE);
#endif
    gchild=GTK_BOX(label_sqlite_file)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.sqlite_file);
    gtk_widget_set_sensitive(label_host, FALSE);
    gtk_widget_set_sensitive(label_user, FALSE);
#endif
    if ( strncmp(config.blank,"fast",strlen(config.blank))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_blank), TRUE);
    if ( strncmp(config.eject,"1",strlen(config.eject))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_eject), TRUE);
    if ( strncmp(config.dao,"1",strlen(config.dao))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_dao), TRUE);
    if ( strncmp(config.joliet,"1",strlen(config.joliet))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_joliet), TRUE);
    if ( strncmp(config.rockridge,"1",strlen(config.rockridge))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_rr), TRUE);
    if ( strncmp(config.usefulRR,"1",strlen(config.usefulRR))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_rrattr), TRUE);
    if ( strncmp(config.dummy,"1",strlen(config.dummy))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_dummy), TRUE);
    if ( strncmp(config.showlog,"1",strlen(config.showlog))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_log), TRUE);
    if ( strncmp(config.showvol,"1",strlen(config.showvol))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_vol), TRUE);
    if ( strncmp(config.pad,"1",strlen(config.pad))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_pad), TRUE);
    if ( strncmp(config.fromimage,"1",strlen(config.fromimage))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_image), TRUE);
    if ( strncmp(config.multi,"1",strlen(config.multi))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_multi), TRUE);
    if ( strncmp(config.burnproof,"1",strlen(config.burnproof))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_burnproof), TRUE);
#ifdef HAVE_LIBMYSQLCLIENT
    if ( strncmp(config.autodic,"1",strlen(config.autodic))==0){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_autodic), TRUE);
    }
#else
#ifdef HAVE_LIBSQLITE
    if ( strncmp(config.autodic,"1",strlen(config.autodic))==0){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_autodic), TRUE);
    }
#else
    gtk_widget_set_sensitive(check_autodic, FALSE);
#endif
#endif
    if ( strncmp(config.stereo,"1",strlen(config.stereo))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_stereo), TRUE);
    if ( strncmp(config.echosound,"1",strlen(config.echosound))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_sound), TRUE);
    if ( strncmp(config.highq,"1",strlen(config.highq))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_high), TRUE);

#ifdef OGGENC
    if ( strncmp(config.encode,"1",strlen(config.encode))==0){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_ogg), TRUE);
    }
#else
    gtk_widget_set_sensitive(radio_ogg, FALSE);
#endif

#ifdef LAME
   if ( strncmp(config.lame,"1",strlen(config.lame))==0){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_mp3), TRUE);
   }
#else
    gtk_widget_set_sensitive(radio_mp3, FALSE);
#endif

    if ( (strncmp(config.lame,"1",strlen(config.lame))==0) || (strncmp(config.encode,"1",strlen(config.encode))==0) )
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_encode), TRUE);
    else
	gtk_widget_set_sensitive(radio_frame, FALSE);

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_image)))
	gtk_widget_set_sensitive(check_multi, FALSE);
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_multi)))
	gtk_widget_set_sensitive(check_image, FALSE);
    gtk_signal_connect(GTK_OBJECT(check_encode), "toggled", G_CALLBACK(encode_toggled), NULL);
    gtk_signal_connect(GTK_OBJECT(check_image), "toggled", G_CALLBACK(image_toggled), NULL);
    gtk_signal_connect(GTK_OBJECT(check_multi), "toggled", G_CALLBACK(multi_toggled), NULL);
    /*****************/

    gtk_box_pack_start(GTK_BOX(hbox[0]), vbox[0], TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox[0]), vbox[1], TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox[1]), vbox[2], TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox[1]), vbox[3], TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(page[0]), hbox[0]);
    gtk_container_add(GTK_CONTAINER(page[1]), hbox[1]);
    tab=gtk_notebook_new();
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(tab), GTK_POS_BOTTOM);
    tab_label[0] = gtk_label_new(_("General"));
    tab_label[1] = gtk_label_new(_("Other"));
    gtk_notebook_insert_page(GTK_NOTEBOOK(tab), page[0], tab_label[0], 0);
    gtk_notebook_insert_page(GTK_NOTEBOOK(tab), page[1], tab_label[1], 1);
    gtk_widget_show_all(tab);
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), tab);
    result=gtk_dialog_run(GTK_DIALOG(dialog));
    switch (result) {
	case GTK_RESPONSE_ACCEPT:
	    gchild=GTK_BOX(label_SCSI)->children->next->data;
	    sprintf(config.scsi, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_speed)->children->next->data;
	    sprintf(config.speed, "%d", gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gchild->widget)));
	    gchild=GTK_BOX(label_image)->children->next->data;
	    sprintf(config.tempdir, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    sprintf(config.fromimage, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_image)));
	    gchild=GTK_BOX(label_log)->children->next->data;
	    sprintf(config.logfile, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_cdrom)->children->next->data;
	    sprintf(config.cdrom, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_cdrw)->children->next->data;
	    sprintf(config.cdrwdevice, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_volid)->children->next->data;
	    sprintf(config.volumeid, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_blank)))
		sprintf(config.blank, "fast");
	    else
		sprintf(config.blank, "all");
	    sprintf(config.eject, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_eject)));
	    sprintf(config.dao, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_dao)));
	    sprintf(config.joliet, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_joliet)));
	    sprintf(config.rockridge, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_rr)));
	    sprintf(config.usefulRR, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_rrattr)));
	    sprintf(config.dummy, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_dummy)));
	    sprintf(config.showlog, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_log)));
	    sprintf(config.showvol, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_vol)));
	    sprintf(config.pad, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_pad)));
	    sprintf(config.multi, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_multi)));
	    sprintf(config.burnproof, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_burnproof)));
	    gchild=GTK_BOX(label_bootimg)->children->next->data;
	    sprintf(config.bootimg, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_mnt)->children->next->data;
	    sprintf(config.mountpoint, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    sprintf(config.autodic, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_autodic)));
	    gchild=GTK_BOX(label_host)->children->next->data;
	    sprintf(config.cdbhost, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_user)->children->next->data;
	    sprintf(config.cdbuser, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_sqlite_file)->children->next->data;
	    sprintf(config.sqlite_file, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_audio)->children->next->data;
	    sprintf(config.audiodir, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    gchild=GTK_BOX(label_bpc)->children->next->data;
	    sprintf(config.bitsperchn, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    sprintf(config.stereo, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_stereo)));
	    sprintf(config.echosound, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_sound)));
	    sprintf(config.highq, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_high)));
	    gchild=GTK_BOX(label_bps)->children->next->data;
	    sprintf(config.bitrate, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
	    if (GTK_WIDGET_SENSITIVE(radio_ogg))
		sprintf(config.encode, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_ogg)));
	    if (GTK_WIDGET_SENSITIVE(radio_mp3))
		sprintf(config.lame, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_mp3)));
	    if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_encode))){
		sprintf(config.encode, "%d", 0);
		sprintf(config.lame, "%d", 0);
	    }
	    write_conf();
	    gtk_widget_destroy(dialog);
	    fill_info_gtk();
	    return TRUE;
	    break;
	default:
	    gtk_widget_destroy(dialog);
	    return FALSE;
	    break;
    }
}

int one_gtk(struct dirent *unused)
{
    if (strcmp(unused->d_name,".") && strcmp(unused->d_name,"..")) {
	return 1;
    }
    else
	return 0;
}

gboolean cdda2wav_gtk(GtkWidget *widget, gpointer user_data)
{
    GtkWidget *dialog, *label_tracks, *spin_start, *spin_end, *msg;
    GtkWidget *hbox, *vbox[2];
    gint result, i;
    char tracks[255], cdinfo[255], *line, tmp[18], cmd[255];
    FILE *fp;
    DIR *directory;
    int start_track=0, end_track=0, max_track=0, tracknum=0;
    GtkBoxChild *gchild;

    sprintf(cdinfo,"%s -D%s -J -H -g", CDDA2WAV, config.cdrom);
    run_command_gtk(cdinfo, _("Load CD info..."), 0, 0, 0, "");

    if ( (fp=fopen(config.logfile,"r"))==NULL){
	fprintf(stderr, _("Cannot open file..."));
	gtk_main_quit();
    }
    line=(char *)malloc(1024);

    while ( (line=fgets(line, 256, fp))!=NULL){
	// T01:      33  2:36.25 audio linear copydenied stereo title '' from ''
	if (sscanf(line, "T%d: %s %s audio %s", &max_track, tmp, tmp, cdinfo) == 4 ){
	    start_track=1;
	    end_track=max_track;
	}
    }

    dialog = gtk_dialog_new_with_buttons(_("Grab Audio CD"), GTK_WINDOW(window1), GTK_DIALOG_MODAL, GTK_STOCK_CLOSE, GTK_RESPONSE_REJECT, NULL);
    hbox=gtk_hbox_new(FALSE, 5);
    for (i=0; i<2; i++){
	vbox[i]=gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox[i], FALSE, FALSE, 0);
    }
    gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);

    if (end_track){
	sprintf(tracks, "%s %d", _("Number of tracks: "), end_track);
	label_tracks=gtk_label_new(tracks);
	gtk_box_pack_start(GTK_BOX(vbox[0]), label_tracks, FALSE, FALSE, 0);
	spin_start=gtk_entry_with_label(_("Start track"), 0, FALSE, 1, start_track, end_track);
	gtk_box_pack_start(GTK_BOX(vbox[0]), spin_start, FALSE, FALSE, 0);
	spin_end=gtk_entry_with_label(_("End track"), 0, FALSE, 1, start_track, end_track);
	gtk_box_pack_start(GTK_BOX(vbox[0]), spin_end, FALSE, FALSE, 0);
	gtk_dialog_add_buttons(GTK_DIALOG(dialog), GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL);
    } else {
	label_tracks=gtk_label_new(_("No audio CD!"));
	gtk_box_pack_start(GTK_BOX(vbox[0]), label_tracks, FALSE, FALSE, 0);
	spin_start=gtk_entry_with_label(_("Start track"), 0, FALSE, 1, start_track, end_track+1);
	gtk_box_pack_start(GTK_BOX(vbox[0]), spin_start, FALSE, FALSE, 0);
	spin_end=gtk_entry_with_label(_("End track"), 0, FALSE, 1, start_track, end_track+1);
	gtk_box_pack_start(GTK_BOX(vbox[0]), spin_end, FALSE, FALSE, 0);
	gtk_widget_set_sensitive(spin_start, FALSE);
	gtk_widget_set_sensitive(spin_end, FALSE);
    }

    check_stereo=gtk_check_button_new_with_label(_("Grab stereo mode"));
    check_sound=gtk_check_button_new_with_label(_("Echo to soundcard"));
    check_high=gtk_check_button_new_with_label(_("High quality"));
    check_encode=gtk_check_button_new_with_label(_("Encode audio"));
    label_bpc=gtk_entry_with_label(_("Bits per channel"), 2, FALSE, 0, 0, 0);
    label_bps=gtk_entry_with_label(_("Bitrate"), 3, FALSE, 0, 0, 0);
    radio_ogg=gtk_radio_button_new_with_label(NULL, _("Encode to Ogg Vorbis"));
    radio_mp3=gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON(radio_ogg), _("Encode to MP3"));
    radio_frame=gtk_frame_new(_("Encode to"));
    radio_vbox=gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(radio_frame), radio_vbox);
    gtk_box_pack_start(GTK_BOX(radio_vbox), radio_ogg, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(radio_vbox), radio_mp3, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_stereo, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_sound, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[0]), check_encode, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), label_bpc, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), check_high, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), label_bps, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox[1]), radio_frame, FALSE, FALSE, 0);

    /*** FILL ***/
    gchild=GTK_BOX(label_bpc)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.bitsperchn);
    gchild=GTK_BOX(label_bps)->children->next->data;
    gtk_entry_set_text(GTK_ENTRY(gchild->widget), config.bitrate);
    if ( strncmp(config.stereo,"1",strlen(config.stereo))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_stereo), TRUE);
    if ( strncmp(config.echosound,"1",strlen(config.echosound))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_sound), TRUE);
    if ( strncmp(config.highq,"1",strlen(config.highq))==0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_high), TRUE);

#ifdef OGGENC
    if ( strncmp(config.encode,"1",strlen(config.encode))==0){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_ogg), TRUE);
    }
#else
    gtk_widget_set_sensitive(radio_ogg, FALSE);
#endif

#ifdef LAME
   if ( strncmp(config.lame,"1",strlen(config.lame))==0){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_mp3), TRUE);
   }
#else
    gtk_widget_set_sensitive(radio_mp3, FALSE);
#endif

    if ( (strncmp(config.lame,"1",strlen(config.lame))==0) || (strncmp(config.encode,"1",strlen(config.encode))==0) )
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_encode), TRUE);
    else
	gtk_widget_set_sensitive(radio_frame, FALSE);
    gtk_signal_connect(GTK_OBJECT(check_encode), "toggled", G_CALLBACK(encode_toggled), NULL);
    /************/

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 0);
    gtk_widget_show_all(dialog);
    result=gtk_dialog_run(GTK_DIALOG(dialog));
    switch (result) {
	case GTK_RESPONSE_ACCEPT:
	    if ((directory=opendir(config.audiodir))==NULL) {
		if (gtk_message(_("Audio directory not exist!\nDo you wish to create?"))){
		    if (mkdir(config.audiodir, S_IRWXU)!=0){
			msg = gtk_message_dialog_new(GTK_WINDOW(dialog), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "Cannot create directory!");
			gtk_window_set_resizable(GTK_WINDOW(msg), FALSE);
			gtk_dialog_run(GTK_DIALOG(msg));
			gtk_widget_destroy(msg);
			break;
		    }
		}
	    }
	    (void) closedir(directory);
	    if ( end_track!=0 ){
		gchild=GTK_BOX(spin_start)->children->next->data;
		start_track=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gchild->widget));
		gchild=GTK_BOX(spin_end)->children->next->data;
		end_track=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gchild->widget));
		gchild=GTK_BOX(label_bpc)->children->next->data;
		sprintf(config.bitsperchn, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
		sprintf(config.stereo, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_stereo)));
		sprintf(config.echosound, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_sound)));
		sprintf(config.highq, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_high)));
		gchild=GTK_BOX(label_bps)->children->next->data;
		sprintf(config.bitrate, "%s", gtk_entry_get_text(GTK_ENTRY(gchild->widget)));
		if (GTK_WIDGET_SENSITIVE(radio_ogg))
		    sprintf(config.encode, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_ogg)));
		if (GTK_WIDGET_SENSITIVE(radio_mp3))
		    sprintf(config.lame, "%d", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_mp3)));
		if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_encode))){
		    sprintf(config.encode, "%d", 0);
		    sprintf(config.lame, "%d", 0);
		}
		write_conf();
		sprintf(cdinfo, "%s ", CDDA2WAV);
		if ( strncmp(config.stereo,"1", strlen(config.stereo))==0)
		    sprintf(cdinfo, "%s -s", cdinfo);
		else
		    sprintf(cdinfo, "%s -m", cdinfo);
		if ( strncmp(config.echosound,"1", strlen(config.echosound))==0){
		    sprintf(cdinfo, "%s -e", cdinfo);
		}
		if ( strncmp(config.encode,"1", strlen(config.encode))==0){
		    char msg[30];
#ifdef OGGENC
		    sprintf(cmd, "%s", cdinfo);
		    for (tracknum=start_track; tracknum<=end_track; tracknum++) {
			if ( strncmp(config.highq,"1", strlen(config.highq))==0){
			   sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -q 8 -o %s/audio_%.2d.ogg -", cmd, config.cdrom, tracknum, config.bitsperchn, OGGENC, config.audiodir, tracknum);
			}
			else
			   sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -b%s -o %s/audio_%.2d.ogg -", cmd, config.cdrom, tracknum, config.bitsperchn, OGGENC, config.bitrate, config.audiodir, tracknum);
		       sprintf(msg, _("Track: %d"), tracknum);
		       run_command_gtk(cdinfo, _("Grab Audio CD"), 0, 0, 1, msg);
		    }
#endif
		} else if ( strncmp(config.lame,"1", strlen(config.lame))==0){
		    char msg[30];
#ifdef LAME
		    sprintf(cmd, "%s", cdinfo);
		    for (tracknum=start_track; tracknum<=end_track; tracknum++) {
			if ( strncmp(config.highq,"1", strlen(config.highq))==0){
			   sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -h -V2 -b%s - %s/audio_%.2d.mp3 -", cmd, config.cdrom, tracknum, config.bitsperchn, LAME, config.bitrate, config.audiodir, tracknum);
			}
			else
			   sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -b%s %s/audio_%.2d.mp3 -", cmd, config.cdrom, tracknum, config.bitsperchn, LAME, config.bitrate, config.audiodir, tracknum);
			sprintf(msg, _("Track: %d"), tracknum);
			run_command_gtk(cdinfo, _("Grab Audio CD"), 0, 0, 1, msg);
		    }
#endif
		} else {
		    char msg[30];

		    sprintf(cmd, "%s", cdinfo);
		    for (tracknum=start_track; tracknum<=end_track; tracknum++) {
			sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H %s/audio_%.2d.wav", cmd, config.cdrom, tracknum, config.bitsperchn, config.audiodir, tracknum);
			sprintf(msg, _("Track: %d"), tracknum);
			run_command_gtk(cdinfo, _("Grab Audio CD"), 0, 0, 1, msg);
		    }
		}
	    }
	    gtk_widget_destroy(dialog);
	    return TRUE;
	    break;
	default:
	    gtk_widget_destroy(dialog);
	    return FALSE;
	    break;
    }
}

void select_row_gtk(GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer user_data)
{
    rowindex=row;
    gtk_clist_get_text(GTK_CLIST(clist), rowindex, 0, &selectedFile);
}


void create_image_gtk(GtkWidget *widget, gpointer user_data)
{
    char command[255];
    gboolean ret=TRUE, exist=TRUE;
    FILE *isofile;
    int boot_exists=1;

    if ( strcmp(config.showvol,"1")==0 )
	ret=gtk_input(_("Volume ID"), _("Enter volume label:"), config.volumeid, 40, FALSE);
    if (ret) {
	sprintf(command,"%s -f", MKISOFS);
	if ( strcmp(config.joliet, "1")==0 ) {
	    strcat(command," -J");
	}
	if ( strcmp(config.rockridge, "1")==0 ) {
	    strcat(command," -r");
	}
	if ( strlen(config.bootimg) ) {
	    char bootimage[255];

	    sprintf(bootimage, "%s/.cdw/%s", getenv("HOME"), config.bootimg);
	    if ( (isofile=fopen(bootimage, "r"))==NULL ){
		boot_exists=gtk_error_message(_("Boot image doesn't exist!"));
		boot_exists=0;
	    }
	    if (boot_exists) {
		fclose(isofile);
		sprintf(command,"%s -b %s -c boot.catalog -no-emul-boot", command, config.bootimg);
	    }
	}
	if (boot_exists) {
	    if ( strlen(config.volumeid) == 0){
		strcpy(config.volumeid, "cdrom");
	    }
	    sprintf(command,"%s -V\"%s\" -o %s %s", command, config.volumeid, config.tempdir, homedir);
	    if ( (isofile=fopen(config.tempdir, "r"))!=NULL ){
		exist=gtk_message(_("Image file exist!\nDo you wish to overwrite it?"));
		fclose(isofile);
	    }
	    if (exist)
	       run_command_gtk(command,_("Create image"), 0, 1, 1, "");
	}
    }
}

void blank_cdrw_gtk(GtkWidget *widget, gpointer user_data)
{
    char command[255];

    sprintf(command,"%s -v speed=%s dev=%s blank=%s",CDRECORD,config.speed,config.scsi,config.blank);
    run_command_gtk(command,_("Blank CD-RW"), 0, 1, 0, _("Blank CD-RW"));
}

void copy_image_win_gtk(GtkWidget *widget, gpointer user_data)
{
    gboolean exist=TRUE;
    FILE *isofile;

    if ( (isofile=fopen(config.tempdir, "r"))!=NULL ){
//       exist=dialogbox(_("Image exist"), _("Image file exist!\nDo you wish to overwrite it?"), 3);
	exist=gtk_message(_("Image file exist!\nDo you wish to overwrite it?"));
        fclose(isofile);
    }
    if (exist)
       copy_image_gtk(_("Copy CD image"));
}

void write_cd_gtk(GtkWidget *widget, gpointer user_data)
{
    char command[255];
    FILE *fp;

    if ( (access(config.tempdir, R_OK)!=-1) && ( strcmp(config.fromimage, "1")==0 ) ){
	sprintf(command,"%s -v speed=%s dev=%s %s",CDRECORD,config.speed,config.scsi,config.other);
	if ( strcmp(config.dao, "1")==0 ){
	    strcat(command, " -dao");
	}
	if ( strcmp(config.dummy, "1")==0 ){
	    strcat(command, " -dummy");
	}
	if ( strcmp(config.burnproof, "1")==0 ){
	    strcat(command, " -driveropts=burnproof");
	}
	sprintf(command,"%s -data %s",command, config.tempdir);
	run_command_gtk(command, _("Write image"), 0, 1, 1, "");
	after_event_gtk("Write image log", 1);
    }
    else if ( strcmp(config.fromimage, "0")==0 ){
	int ismulti=0;
	char tsizecmd[255];
	char mkisofscmd[255];
	FILE *isofile;
	int boot_exists=1;

	gboolean ret=TRUE;
	if ( strcmp(config.showvol,"1")==0 )
	    ret=gtk_input(_("Volume ID"), _("Enter volume label:"), config.volumeid, 40, FALSE);
	if (ret) {
	    sprintf(command,"%s -f", MKISOFS);
	    if ( strcmp(config.joliet, "1")==0 ) {
		strcat(command," -J");
	    }
	    if ( strcmp(config.rockridge, "1")==0 ) {
		strcat(command," -R");
	    }
	    if ( strcmp(config.usefulRR, "1")==0 ) {
		strcat(command," -r");
	    }
	    if ( strlen(config.bootimg) ) {
		char bootimage[255];

		sprintf(bootimage, "%s/.cdw/%s", getenv("HOME"), config.bootimg);
		if ( (isofile=fopen(bootimage, "r"))==NULL ){
		    boot_exists=gtk_error_message(_("Boot image doesn't exist!"));
		    boot_exists=0;
		}
		if (boot_exists) {
		    fclose(isofile);
		    sprintf(command,"%s -b %s -c boot.catalog -no-emul-boot", command, config.bootimg);
		}
	    }
	    if (boot_exists) {
		if ( strcmp(config.multi, "1")==0 ) {
		    char msinfo[255];
		    char *line;
		    int track_start=0, track_end=0;
		    sprintf(msinfo,"%s dev=%s -msinfo", CDRECORD, config.scsi);
		    run_command_gtk(msinfo, _("Load CD info..."), 0, 0, 0, "");
		    if ( (fp=fopen(config.logfile,"r"))==NULL){
			fprintf(stderr, _("Cannot open file..."));
			gtk_main_quit();
		    }
		    line=(char *)malloc(1024);
		    while ( (line=fgets(line, 256, fp))!=NULL){
			if ( sscanf(line, "%d,%d", &track_start, &track_end) == 2 ){
			    ismulti=1;
			}
		    }
		    if (ismulti==1) {
			sprintf(command,"%s -C %d,%d -M %s",command, track_start, track_end, config.cdrwdevice);
		    }
		    fclose(fp);
		    free(line);
		}
		if ( strlen(config.volumeid) == 0){
		    strcpy(config.volumeid, "cdrom");
		}
		sprintf(tsizecmd, "tsize=`%s -print-size -quiet %s`", command, homedir);
		sprintf(mkisofscmd,"%s; %s -V\"%s\" %s", tsizecmd, command, config.volumeid, homedir);
		sprintf(command,"%s | %s -v speed=%s dev=%s -tsize=${tsize}s %s", mkisofscmd, CDRECORD, config.speed,config.scsi,config.other);
		//sprintf(command,"%s -V\"%s\" %s", command, config.volumeid, homedir);
		//sprintf(command,"%s | %s -v speed=%s dev=%s %s",command, CDRECORD,config.speed,config.scsi,config.other);
		if ( strcmp(config.dao, "1")==0 ){
		    strcat(command, " -dao");
		}
		if ( strcmp(config.dummy, "1")==0 ){
		    strcat(command, " -dummy");
		}
		if ( strcmp(config.multi, "1")==0){
		    strcat(command, " -multi");
		}
		if ( strcmp(config.burnproof, "1")==0 ){
		    strcat(command, " -driveropts=burnproof");
		}
		sprintf(command,"%s -",command);
		run_command_gtk(command, _("Write direct"), size_gtk, 1, 1, "");
		after_event_gtk(_("Write direct log"), 1);
	    }
	}
    }
}


void write_audio_gtk(GtkWidget *widget, gpointer user_data)
{
    char command[255];
    gboolean ret=TRUE;

    if ( strcmp(config.showvol,"1")==0 )
	ret=gtk_input((char*)_("Volume ID"), _("Enter volume label:"), config.volumeid, 40, FALSE);
    if (ret) {
	sprintf(command,"%s -v speed=%s dev=%s -audio",CDRECORD,config.speed,config.scsi);
	if ( strcmp(config.pad, "1")==0 ){
	    strcat(command, " -pad");
	}
	if ( strcmp(config.dao, "1")==0 ){
	    strcat(command, " -dao");
	}
	if ( strcmp(config.dummy, "1")==0 ){
	    strcat(command, " -dummy");
	}
	if ( strcmp(config.burnproof, "1")==0 ){
	    strcat(command, " -driveropts=burnproof");
	}
	sprintf(command,"%s %s/*.wav",command,homedir);
	run_command_gtk(command, _("Write audio"), size_gtk, 1, 1, "");
	after_event_gtk(_("Write audio log"), 1);
    }
}


void copy_data_gtk(GtkWidget *widget, gpointer user_data)
{
    char command[255];
    int in_fd;

    if ( (in_fd = open("/dev/cdrom", O_RDONLY)) != -1 ){
	close(in_fd);
	sprintf(command,"%s -v speed=%s dev=%s %s",CDRECORD,config.speed,config.scsi,config.other);
	if ( strcmp(config.eject, "1")==0 ){
	    strcat(command, " -eject");
	}
	if ( strcmp(config.dummy, "1")==0 ){
	    strcat(command, " -dummy");
	}
	sprintf(command,"%s -isosize %s",command, config.cdrom);
	run_command_gtk(command, _("Copy data CD"), 0, 1, 1, "");
	after_event_gtk(_("Copy data CD log"), 1);
    }
}

void store_filename(GtkWidget *widget, gpointer user_data)
{
    const gchar *selected_filename;
    char path[2000], linkfile[2000], newlink[2000];
    struct stat stbuf;
    char name[1000];
    char *pos;
    int screenpos;
    GError *err;

    selected_filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fileselect));
    if (strlen(g_path_get_basename(selected_filename))>0) {
	sprintf(newlink, "%s/%s", homedir, g_path_get_basename(selected_filename));
	symlink(selected_filename, newlink);
	select_window_gtk(TRUE);
//	g_print ("Selected filename: %s\n", g_path_get_basename(selected_filename));
    }
}

void add_files_gtk(GtkWidget *widget, gpointer data)
{
    fileselect=gtk_file_selection_new(_("Select files"));
    g_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fileselect)->ok_button), "clicked", G_CALLBACK(store_filename), NULL);
    g_signal_connect_swapped(GTK_OBJECT(GTK_FILE_SELECTION(fileselect)->ok_button), "clicked", G_CALLBACK(gtk_widget_destroy), (gpointer)fileselect);
    g_signal_connect_swapped(GTK_OBJECT(GTK_FILE_SELECTION(fileselect)->cancel_button), "clicked", G_CALLBACK(gtk_widget_destroy), (gpointer)fileselect);
    gtk_widget_show(fileselect);
}

void delete_files_gtk(GtkWidget *widget, gpointer data)
{
    int c;
    char filetodelete[255]="\0";

    if (rowindex>=0){
	strcpy(filetodelete, homedir);
	strcat(filetodelete,"/");
	strcat(filetodelete, selectedFile);
	unlink(filetodelete);
	gtk_clist_remove(GTK_CLIST(filelist), rowindex);
	select_window_gtk(FALSE);
    }
}

double dirsize_gtk(char *dir)
{
    struct dirent **eps;
    struct stat *finfo;
    int n, ok, err, type, cnt;
    char *dname, *ch, ftime[256];

    n = scandir(dir, &eps, (void *)one_gtk, alphasort);
    if (n>=0) {
	for (cnt=0; cnt<n; ++cnt){
    	    ch=(char *) malloc(strlen(eps[cnt]->d_name)+strlen(dir)+4+1);
	    sprintf(ch,"%s/%s",dir,eps[cnt]->d_name);
	    finfo=(struct stat *)malloc(sizeof(finfo)+100);
	    ok=lstat(ch,finfo);
	    if ( (eps[cnt]->d_type=DT_DIR) )
		dirsize_gtk(ch);
	    if (ok=stat(ch,finfo)!=0);
	    else {
		size_gtk+=finfo->st_size;
	    }
	    free(finfo);
    	    free(ch);
	}
    }
    return size_gtk;
}

void space_gtk(double size)
{
    int i;
    float percent;
    char wasted_msg[200];

    if (size<=config.cdsize) {
	percent=(size / ((float)config.cdsize / 100));
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(size_bar), percent/100);
    }
    else {
	percent=(float)(100);
//	percent=(size / ((float)config.cdsize / 100));
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(size_bar), percent/100);
    }
    if ( config.cdsize-size >= 0 ) {
	sprintf(wasted_msg, _("Used: %2.1f%%, Wasted: %.0f/%d MB"), percent, config.cdsize-size,config.cdsize);
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(size_bar), wasted_msg);
    } else {
	sprintf(wasted_msg, _("Used: %2.1f%%, Wasted: %d MB"), percent, config.cdsize);
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(size_bar), wasted_msg);
    }
}

int select_window_gtk(bool real)
{
    struct dirent **cdfiles;
    int pos=0, datasize=0, num, i;
    gchar *column[2], msg_text[255];
    struct stat *finfo;
    int ok, err, fsize;
    char *ch;

    if (real==TRUE) {
	gtk_clist_clear(GTK_CLIST(filelist));
	num = scandir(homedir, &cdfiles, (void *)one_gtk, alphasort);
	if (num>0) {
    	    for (i=0; i<num; ++i) {
    		if ( cdfiles[i]->d_type==DT_DIR ){
		    column[0]=(char *)malloc(strlen(cdfiles[i]->d_name)+1);
		    sprintf(column[0], "%s", cdfiles[i]->d_name);
		    column[1]=(char *)malloc(4);
		    sprintf(column[1], "%s", "DIR");
		    gtk_clist_append(GTK_CLIST(filelist), column);
		}
	    }
	    for (i=0; i<num; ++i) {
		if ( cdfiles[i]->d_type!=DT_DIR ){
		    ch=(char *) malloc(strlen(cdfiles[i]->d_name)+strlen(homedir)+4+1);
		    sprintf(ch,"%s/%s",homedir,cdfiles[i]->d_name);
		    finfo=(struct stat *)malloc(sizeof(finfo)+100);
		    ok=lstat(ch,finfo);
		    if (ok=stat(ch,finfo)!=0);
		    else {
			fsize=finfo->st_size/1024;
		    }
		    free(finfo);
		    free(ch);
		    column[0]=(char *)malloc(strlen(cdfiles[i]->d_name)+1);
		    sprintf(column[0], "%s", cdfiles[i]->d_name);
		    column[1]=(char *)malloc(5);
		    sprintf(column[1], "%dKb", fsize);
		    gtk_clist_append(GTK_CLIST(filelist), column);
		}
	    }
	}
    }
    size_gtk=0;
    sprintf(msg_text, _("Size: %.0f Mb in %d files"), dirsize_gtk(homedir)/1024/1024, num);
    gtk_label_set_text(GTK_LABEL(size_msg), msg_text);
    space_gtk(size_gtk/1024/1024);
}

void fill_info_gtk()
{
    char speed[30];
    if (strcmp(config.fromimage, "1")==0)
	gtk_label_set_text(GTK_LABEL(info[0]), _("Write from image"));
    else
	gtk_label_set_text(GTK_LABEL(info[0]), _("Write direct    "));
    sprintf(speed, "%s %sX", _("Speed:"), config.speed);
    gtk_label_set_text(GTK_LABEL(info[1]), speed);
    if (strcmp(config.multi, "1")==0)
	gtk_label_set_text(GTK_LABEL(info[2]), _("Multi-session "));
    else
	gtk_label_set_text(GTK_LABEL(info[2]), _("Single session"));
}

void QuitCdw(GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

void add_toolbar_item(GtkWidget *toolbar, char *text, char *tooltip, gchar *iconname, int pos, GtkWidget *toolbar_image, GtkWidget *toolbar_item, GtkSignalFunc callback)
{
    char imagefile[255];

    sprintf(imagefile, "%s/pixmaps/%s", CDWDIR, iconname);
    toolbar_image=gtk_image_new_from_file(imagefile);
    toolbar_item=gtk_toolbar_insert_item(GTK_TOOLBAR(toolbar), text, tooltip, "", toolbar_image, callback, NULL, pos);
}

int gtk_gui(int argc, char *argv[])
{
#define GTK_MODE 1
    gint i;
    gchar *title, imagefile[255];
    GtkWidget *main_vbox, *main_hbox, *menu_box, *frame1, *frame2, *info_frame, *info_box, *vbox;
    GtkWidget *button[9], *size_frame, *size_box, *align;
    GtkWidget *toolbar_items[10], *toolbar_images[10];
    GtkAdjustment *adj;
    GdkPixbuf *icon;


    bind_textdomain_codeset(PACKAGE, "UTF-8");
    gtk_init(0, &argv);

    sprintf(homedir,"%.225s/.cdw",getenv("HOME"));
    mkdir(homedir,S_IRWXU);
    read_conf();
    window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    sprintf(imagefile, "%s/pixmaps/cdw.png", CDWDIR);
    icon=gdk_pixbuf_new_from_file(imagefile, NULL);
    gtk_window_set_icon(GTK_WINDOW(window1), icon);
    gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
    gtk_signal_connect(GTK_OBJECT(window1), "destroy", GTK_SIGNAL_FUNC(QuitCdw), NULL);
    title=(gchar *)malloc(strlen(VERSION)+strlen(PACKAGE)+2);
    sprintf(title, "%s-%s", PACKAGE, VERSION);
    gtk_window_set_title (GTK_WINDOW (window1), title);
    gtk_window_set_default_size (GTK_WINDOW (window1), 580, 440);

    main_vbox=gtk_vbox_new(FALSE, 1);
    main_hbox=gtk_hbox_new(FALSE, 1);

    toolbar=gtk_toolbar_new();
    gtk_box_pack_start(GTK_BOX(main_vbox), toolbar, FALSE, FALSE, 0);
    gtk_widget_show(toolbar);

    add_toolbar_item(toolbar, _("CD label"), _("Display CD label editor window"), "cdlabel.png", 0, toolbar_images[1], toolbar_items[1], GTK_SIGNAL_FUNC(volume_id_gtk));
    add_toolbar_item(toolbar, _("Parameters"), _("Edit cdrecord parameters"), "parameters.png", 1, toolbar_images[2], toolbar_items[2], GTK_SIGNAL_FUNC(parameters_gtk));
    add_toolbar_item(toolbar, _("CD Size"), _("Select the size of disk"), "cdsize.png", 2, toolbar_images[3], toolbar_items[3], GTK_SIGNAL_FUNC(select_size_gtk));
    add_toolbar_item(toolbar, _("Log"), _("Display the content of log"), "log.png", 3, toolbar_images[4], toolbar_items[4], GTK_SIGNAL_FUNC(log_window_gtk));
    add_toolbar_item(toolbar, _("CD info"), _("Display information about CD"), "cdinfo.png", 4, toolbar_images[5], toolbar_items[5], GTK_SIGNAL_FUNC(show_cd_info_gtk));
    add_toolbar_item(toolbar, _("Eject CD"), _("Eject CD tray"), "eject.png", 5, toolbar_images[6], toolbar_items[6], GTK_SIGNAL_FUNC(eject_gtk));
#ifdef HAVE_LIBMYSQLCLIENT
    add_toolbar_item(toolbar, _("Disk catalog"), _("Display disk catalog"), "cdwdic.png", 6, toolbar_images[7], toolbar_items[7], GTK_SIGNAL_FUNC(cddb_window_gtk));
    add_toolbar_item(toolbar, _("Add disk"), _("Add CD to disk catalog"), "cdadd.png", 7, toolbar_images[8], toolbar_items[8], GTK_SIGNAL_FUNC(add_to_dic_gtk));
#endif
#ifdef HAVE_LIBSQLITE
    add_toolbar_item(toolbar, _("Disk catalog"), _("Display disk catalog"), "cdwdic.png", 6, toolbar_images[7], toolbar_items[7], GTK_SIGNAL_FUNC(cddb_window_gtk));
    add_toolbar_item(toolbar, _("Add disk"), _("Add CD to disk catalog"), "cdadd.png", 7, toolbar_images[8], toolbar_items[8], GTK_SIGNAL_FUNC(add_to_dic_gtk));
#endif
    add_toolbar_item(toolbar, _("CD rip"), _("Rip Audio CD"), "cdrip.png", 8, toolbar_images[9], toolbar_items[9], GTK_SIGNAL_FUNC(cdda2wav_gtk));
    add_toolbar_item(toolbar, _("Help"), _("Display help window"), "help.png", 9, toolbar_images[0], toolbar_items[0], GTK_SIGNAL_FUNC(help_win_gtk));

    frame1=gtk_frame_new(_("Menu"));
    gtk_box_pack_start(GTK_BOX(main_hbox), frame1, FALSE, FALSE, 0);
    gtk_widget_show(frame1);
    menu_box=gtk_vbox_new(FALSE, 1);
    gtk_container_add(GTK_CONTAINER(frame1), menu_box);
    gtk_widget_show(menu_box);
    button[0]=gtk_button_new_with_label(_("Add files..."));
    button[1]=gtk_button_new_with_label(_("Delete files"));
    button[2]=gtk_button_new_with_label(_("Create image"));
    button[3]=gtk_button_new_with_label(_("Copy CD image"));
    button[4]=gtk_button_new_with_label(_("Write data CD"));
    button[5]=gtk_button_new_with_label(_("Write audio CD"));
    button[6]=gtk_button_new_with_label(_("Copy data CD"));
    button[7]=gtk_button_new_with_label(_("Blank CD-RW"));
    button[8]=gtk_button_new_with_label(_("Options..."));
    button[9]=gtk_button_new_with_label(_("Quit"));

    /*** BUTTON EVENTS ***/
    gtk_signal_connect(GTK_OBJECT(button[0]), "clicked", GTK_SIGNAL_FUNC(add_files_gtk), NULL);
    gtk_signal_connect(GTK_OBJECT(button[1]), "clicked", GTK_SIGNAL_FUNC(delete_files_gtk), NULL);
    gtk_signal_connect(GTK_OBJECT(button[2]), "clicked", GTK_SIGNAL_FUNC(create_image_gtk), NULL);
    gtk_signal_connect(GTK_OBJECT(button[3]), "clicked", GTK_SIGNAL_FUNC(copy_image_win_gtk), NULL);
    gtk_signal_connect(GTK_OBJECT(button[4]), "clicked", GTK_SIGNAL_FUNC(write_cd_gtk), NULL);
    gtk_signal_connect(GTK_OBJECT(button[5]), "clicked", GTK_SIGNAL_FUNC(write_audio_gtk), NULL);
    gtk_signal_connect(GTK_OBJECT(button[6]), "clicked", GTK_SIGNAL_FUNC(copy_data_gtk), NULL);
    gtk_signal_connect(GTK_OBJECT(button[7]), "clicked", GTK_SIGNAL_FUNC(blank_cdrw_gtk), NULL);
    gtk_signal_connect(GTK_OBJECT(button[8]), "clicked", GTK_SIGNAL_FUNC(options_gtk), NULL);
    /*********************/

    gtk_signal_connect(GTK_OBJECT(button[9]), "clicked", GTK_SIGNAL_FUNC(QuitCdw), NULL);
    for (i=0; i<=9; i++) {
	    gtk_box_pack_start(GTK_BOX(menu_box), button[i], FALSE, FALSE, 0);
	    gtk_widget_show(button[i]);
    }
    info_frame=gtk_frame_new(_("Info"));
    gtk_box_pack_end(GTK_BOX(menu_box), info_frame, FALSE, TRUE, 0);
    gtk_widget_show(info_frame);
    info_box=gtk_vbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(info_frame), info_box);
    gtk_widget_show(info_box);
    info[0]=gtk_label_new("");
    info[1]=gtk_label_new("");
    info[2]=gtk_label_new("");
    for (i=0; i<=2; i++) {
	    gtk_misc_set_alignment(GTK_MISC(info[i]), 0.0, 0.0);
	    gtk_box_pack_start(GTK_BOX(info_box), info[i], TRUE, TRUE, 2);
	    gtk_widget_show(info[i]);
    }
    frame2=gtk_frame_new(_("Selected files:"));
    gtk_box_pack_start(GTK_BOX(main_hbox), frame2, TRUE, TRUE, 0);
    gtk_widget_show(frame2);
    vbox=gtk_vbox_new(FALSE, 1);
    gtk_container_add(GTK_CONTAINER(frame2), vbox);
    scroll_win=gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(vbox), scroll_win, TRUE, TRUE, 0);
    filelist=gtk_clist_new(2);
    gtk_clist_set_column_title(GTK_CLIST(filelist), 0, _("Filename"));
    gtk_clist_set_column_title(GTK_CLIST(filelist), 1, _("Size/Type"));
    gtk_clist_set_column_width(GTK_CLIST(filelist), 0, 300);
    gtk_container_add(GTK_CONTAINER(scroll_win), filelist);
    gtk_widget_show(scroll_win);
    gtk_widget_show(vbox);
    gtk_widget_show(filelist);
    gtk_signal_connect(GTK_OBJECT(filelist), "select_row", GTK_SIGNAL_FUNC(select_row_gtk), NULL);
    size_frame=gtk_frame_new(_("Size:"));
    gtk_box_pack_end(GTK_BOX(vbox), size_frame, FALSE, TRUE, 0);
    gtk_widget_show(size_frame);
    size_box=gtk_vbox_new(FALSE, 1);
    gtk_container_add(GTK_CONTAINER(size_frame), size_box);
    gtk_widget_show(size_box);
    align = gtk_alignment_new (0.1, 0.1, 0, 0);
    gtk_box_pack_start (GTK_BOX (size_box), align, TRUE, TRUE, 5);
    gtk_widget_show(align);
    size_msg=gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(size_box), size_msg, TRUE, TRUE, 2);
    gtk_widget_show(size_msg);
    adj = (GtkAdjustment *) gtk_adjustment_new(0, 0, config.cdsize, 0, 0, 0);
    size_bar=gtk_progress_bar_new_with_adjustment(GTK_ADJUSTMENT(adj));
    gtk_box_pack_start(GTK_BOX(size_box), size_bar, FALSE, FALSE, 5);
    gtk_widget_show(size_bar);
    gtk_container_add(GTK_CONTAINER(main_vbox), main_hbox);
    gtk_container_add(GTK_CONTAINER(window1), main_vbox);
    gtk_widget_show(main_hbox);
    gtk_widget_show(main_vbox);
    gtk_widget_show(window1);

    fill_info_gtk();
    select_window_gtk(TRUE);
    gdk_threads_enter();
    gtk_main();
    gdk_threads_leave();
}
#endif
