#ifndef __CDW_UI_H
#define __CDW_UI_H

#include <ncurses.h>
#include <dirent.h>

typedef struct file_item {
	char filename[255];
	int type;
	int size;
} fileitem;

int fill_filelist(char *dir, fileitem **filei, struct dirent **eps, int n);


void nice_box(WINDOW *window, char *top_string, char *bottom_string, int width);
void put_addwin(int width, int height, int y, int x);
int input_box(char *title, char *label, char *prop, int mode);

void put_mainform(void);
int destroy_mainform(void);

int select_window(bool real);
int blank_method_selector(void);
int cdw_title_init(void);
void scroll_addlist(WINDOW *addwinlist, int menupos, fileitem *filei, int maxfiles);
void clean_cdmenu(void);
void clean_menu(void);
void clean_title(void);
int cdw_curses_init(void);

enum dialog_type {
	DIALOG_OK = 0,
	DIALOG_OK_CANCEL = 3,
	DIALOG_YES_NO_CANCEL = 4
};

enum dialog_button {
	BUTTON_OK = 0,
	BUTTON_YES = 1,
	BUTTON_NO = 2,
	BUTTON_CANCEL = 3
};

int dialogbox(char *message, char *title, int type);

#endif // _CDW_UI_H
