/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <ncurses.h>
#include <fcntl.h>
#include <nl_types.h>
#include <libintl.h>
#include "options.h"
#include "gettext.h"
#include "config.h"

WINDOW *help;

void show_help_main()
{
    int c;
    help=newwin(20,60,(LINES-20)/2,(COLS-60)/2);
    wbkgd(help, COLOR_PAIR(2));
    werase(help);
    box(help,0,0);
    keypad(help, TRUE);
    mvwaddch(help, 0, 2, ACS_RTEE);
    mvwprintw(help, 0, 3, " %s ", _("Help"));
    waddch(help, ACS_LTEE);    
    mvwprintw(help, 19, 2, "( %s )", _("Press ESC to close window"));
    mvwprintw(help, 2, 2, "%s", _("F1  - Show help"));
    mvwprintw(help, 3, 2, "%s", _("F2  - CD label window"));
    mvwprintw(help, 4, 2, "%s", _("F3  - Edit cdrecord parameters"));
    mvwprintw(help, 5, 2, "%s", _("F4  - Select CD size"));
    mvwprintw(help, 6, 2, "%s", _("F5  - View last log"));
    mvwprintw(help, 7, 2, "%s", _("F6  - Information about raw disk material"));
    mvwprintw(help, 8, 2, "%s", _("F10 - View the GPL"));
    mvwprintw(help, 9, 2, "%s", _("E   - Eject tray of CD-RW"));
    mvwprintw(help, 10, 2, "%s", _("C   - Disk catalog"));
    mvwprintw(help, 11, 2, "%s", _("A   - Add disk into Disk catalog"));
    mvwprintw(help, 12, 2, "%s", _("G   - Grab audio CD"));
    mvwprintw(help, 13, 2, "%s", _("Q   - Quit"));
    wrefresh(help);
    while (c!=27) {
	c=wgetch(help);
    }
    delwin(help);
}

void show_help_cddb()
{
    int c;
    help=newwin(20,60,(LINES-20)/2,(COLS-60)/2);
    wbkgd(help, COLOR_PAIR(2));
    werase(help);
    box(help,0,0);
    keypad(help, TRUE);
    mvwaddch(help, 0, 2, ACS_RTEE);
    mvwprintw(help, 0, 3, " %s ", _("Help"));
    waddch(help, ACS_LTEE);    
    mvwprintw(help, 19, 2, "( %s )", _("Press ESC to close window"));
    mvwprintw(help, 2, 2, "%s", _("->     - Step into catalogized files window"));
    mvwprintw(help, 3, 2, "%s", _("<-     - Step into menu window"));
    mvwprintw(help, 4, 2, "%s", _("ENTER  - Change category or disk or directory"));
    mvwprintw(help, 5, 2, "%s", _("BSPACE"));
    mvwprintw(help, 6, 2, "%s", _("/      - Move one level up"));
    mvwprintw(help, 7, 2, "%s", _("DEL    - Delete category or disk"));
    mvwprintw(help, 8, 2, "%s", _("A      - Add disk into catalog"));
    mvwprintw(help, 9, 2, "%s", _("S      - Show all disks"));
    mvwprintw(help,10, 2, "%s", _("Q      - Quit Disk catalog"));

    wrefresh(help);
    while (c!=27) {
	c=wgetch(help);
    }
    delwin(help);
}
