/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _StationData_H_
#define _StationData_H_
//
// $Id: StationData.H,v 1.10 2001/08/01 21:50:46 lijewski Exp $
//
#include <iostream>
#include <fstream>
#include <string>

#include <Amr.H>
#include <Array.H>
#include <REAL.H>
#include <StateData.H>
#include <Utility.H>
//
// Forward declaration.
//
class AmrLevel;

struct StationRec
{
    StationRec ();

    Real pos[BL_SPACEDIM]; // Physical coordinates
    int  id;               // Identifier
    int  level;            // Finest level containing station
    int  grd;              // Index of BoxArray containing FAB
    bool own;              // Does this CPU own the data at grd?
};

class StationData
{
public:

    ~StationData ();
    //
    // Init from ParmParse.
    //
    // ParmParse variables:
    //
    //   StationData.vars     -- Names of StateData components to output
    //   StationData.coord    -- BL_SPACEDIM array of Reals
    //   StationData.coord    -- the next one
    //   StationData.coord    -- ditto ...
    //
    // Data files have the form: "Station/stn_CPU_NNNN"
    //
    void init ();
    //
    // Collect data for all station points at level and write to station file.
    //
    void report (Real            time,
                 int             level,
                 const AmrLevel& amrlevel);
    //
    // Locate finest level grid for each station point.
    //
    void findGrid (const PArray<AmrLevel>& levels,
                   const Array<Geometry>&  geoms);
private:

    Array<StationRec>  m_stn;   // Array of stations.
    Array<std::string> m_vars;  // Names of StateData components to output.
    std::vector<bool>  m_IsDerived;  // true if the variable is a derived quantity
    Array<int>         m_typ;   // The state_index corresponding to m_vars.
    Array<int>         m_ncomp; // The component of the state_index for m_typ.
    std::ofstream      m_ofile; // Output stream.
};

#endif /*_StationData_H_*/

