/***************************************************************************
 *   Copyright (C) 2004-2010 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.3.6. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2B_H
#define C2B_H

#include "c2bBibParser.h"
#include "c2bNetworkQueryInfo.h"

#include <metadataParser.h>
#include <network.h>

#include <QObject>

class QProgressDialog;
class QWidget;


class c2b : public QObject
{

    Q_OBJECT

public:
    c2b(QWidget* main, QObject* parento = 0);
    ~c2b();

    // Actions
    inline static const QString documentMetadata(const QString& fn)
    {
        return metaParser()->metadata(fn);
    }

    inline static const QString encodeLink(const QString& ln)
    {
        return netqinf()->encodeLink(ln);
    }

    inline static void showMessage(const QString& message)
    {
        instance()->emitMessage(message);
    }

    inline static void doSearchInFiles(const QString& string, const QString& fn)
    {
        instance()->emitSearchInFiles(string, fn);
    }

    // Pointers
    inline static c2b* instance()
    {
        Q_ASSERT_X(c2b_single_instance, "c2b", "cb2Bib resources were not instantiated");
        return c2b_single_instance;
    }

    inline static QWidget* mainWidget()
    {
        return instance()->c2b_main;
    }

    inline static network* net()
    {
        return instance()->c2b_network;
    }

    inline static c2bNetworkQueryInfo* netqinf()
    {
        return instance()->c2b_netqinf;
    }

    inline static c2bBibParser* bibParser()
    {
        return instance()->c2b_bibparser;
    }

    inline static metadataParser* metaParser()
    {
        return instance()->c2b_metadataparser;
    }


public slots:
    static void configure(int index = -1);
    void exitRequested();


signals:
    void searchInFiles(const QString& string, const QString& fn);
    void statusMessage(const QString& message);


private:
    QProgressDialog* downloadProgress;
    QWidget* c2b_main;
    c2bBibParser* c2b_bibparser;
    c2bNetworkQueryInfo* c2b_netqinf;
    metadataParser* c2b_metadataparser;
    network* c2b_network;
    static c2b* c2b_single_instance;

    inline void emitMessage(const QString& message)
    {
        emit statusMessage(message);
    }

    inline void emitSearchInFiles(const QString& string, const QString& fn)
    {
        emit searchInFiles(string, fn);
    }


private slots:
    void proxyAuthenticationRequired(const QNetworkProxy& proxy, QAuthenticator* auth);
    void showMessage(const QString& title, const QString& ms);
    void updateDownloadProgress(qint64 bytesReceived, qint64 bytesTotal);

};

#endif
