/*
 * Decompiled with CFR 0.152.
 */
package net.caudium.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;

public class Search {
    private Searcher searcher;
    private String[] stopwords;
    private final String[] attrib = new String[]{"url", "title", "desc", "date", "type"};

    public Search(String string, String[] stringArray) throws IOException {
        this.stopwords = stringArray;
        this.searcher = new IndexSearcher(string);
    }

    public ArrayList search(String string) throws Exception {
        ArrayList arrayList = this.search(string, 0, Integer.MAX_VALUE);
        return arrayList;
    }

    public ArrayList search(String string, int n, int n2) throws Exception {
        Query query = QueryParser.parse((String)string, (String)"body", (Analyzer)new StandardAnalyzer(this.stopwords));
        Hits hits = this.searcher.search(query);
        ArrayList arrayList = new ArrayList(hits.length());
        int n3 = n;
        while (arrayList.size() < n2 && n3 < hits.length()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n4 = 0;
            while (n4 < this.attrib.length) {
                hashMap.put(this.attrib[n4], hits.doc(n3).get(this.attrib[n4]));
                ++n4;
            }
            hashMap.put("score", new Float(hits.score(n3)));
            arrayList.add(hashMap);
            ++n3;
        }
        return arrayList;
    }

    public void close() throws Exception {
        this.searcher.close();
    }
}

