/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;

public abstract class OutputStream {
    static final int BUFFER_SIZE = 1024;
    private final byte[] buffer = new byte[1024];
    private long bufferStart = 0L;
    private int bufferPosition = 0;

    public final void writeByte(byte by) throws IOException {
        if (this.bufferPosition >= 1024) {
            this.flush();
        }
        this.buffer[this.bufferPosition++] = by;
    }

    public final void writeBytes(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this.writeByte(byArray[n2]);
            ++n2;
        }
    }

    public final void writeInt(int n) throws IOException {
        this.writeByte((byte)(n >> 24));
        this.writeByte((byte)(n >> 16));
        this.writeByte((byte)(n >> 8));
        this.writeByte((byte)n);
    }

    public final void writeVInt(int n) throws IOException {
        while ((n & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(n & 0x7F | 0x80));
            n >>>= 7;
        }
        this.writeByte((byte)n);
    }

    public final void writeLong(long l) throws IOException {
        this.writeInt((int)(l >> 32));
        this.writeInt((int)l);
    }

    public final void writeVLong(long l) throws IOException {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(l & 0x7FL | 0x80L));
            l >>>= 7;
        }
        this.writeByte((byte)l);
    }

    public final void writeString(String string) throws IOException {
        int n = string.length();
        this.writeVInt(n);
        this.writeChars(string, 0, n);
    }

    public final void writeChars(String string, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte((byte)c);
            } else if (c >= '\u0080' && c <= '\u07ff' || c == '\u0000') {
                this.writeByte((byte)(0xC0 | c >> 6));
                this.writeByte((byte)(0x80 | c & 0x3F));
            } else {
                this.writeByte((byte)(0xE0 | c >>> 12));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c & 0x3F));
            }
            ++n4;
        }
    }

    protected final void flush() throws IOException {
        this.flushBuffer(this.buffer, this.bufferPosition);
        this.bufferStart += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    protected abstract void flushBuffer(byte[] var1, int var2) throws IOException;

    public void close() throws IOException {
        this.flush();
    }

    public final long getFilePointer() throws IOException {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long l) throws IOException {
        this.flush();
        this.bufferStart = l;
    }

    public abstract long length() throws IOException;
}

