{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetCreateParticles: boolean;
    procedure SetCreateParticles(const Value: boolean);
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    function GetLifetimeVariation: Single;
    procedure SetLifetimeVariation(const Value: Single);
    function GetMaxParticles: Integer;
    procedure SetMaxParticles(const Value: Integer);
    function GetParticleLifetime: Single;
    procedure SetParticleLifetime(const Value: Single);
    function GetParticleSize: TVector2Single;
    procedure SetParticleSize(const Value: TVector2Single);
  public
    property CreateParticles: boolean read GetCreateParticles write SetCreateParticles;
    property Enabled: boolean read GetEnabled write SetEnabled;
    property LifetimeVariation: Single read GetLifetimeVariation write SetLifetimeVariation;
    property MaxParticles: Integer read GetMaxParticles write SetMaxParticles;
    property ParticleLifetime: Single read GetParticleLifetime write SetParticleLifetime;
    property ParticleSize: TVector2Single read GetParticleSize write SetParticleSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TParticleSystemNode ----------------------------------------------- }

function TParticleSystemNode.GetCreateParticles: boolean;
begin
  Result := FdCreateParticles.Value;
end;

procedure TParticleSystemNode.SetCreateParticles(const Value: boolean);
begin
  FdCreateParticles.Send(Value);
end;

function TParticleSystemNode.GetEnabled: boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TParticleSystemNode.SetEnabled(const Value: boolean);
begin
  FdEnabled.Send(Value);
end;

function TParticleSystemNode.GetLifetimeVariation: Single;
begin
  Result := FdLifetimeVariation.Value;
end;

procedure TParticleSystemNode.SetLifetimeVariation(const Value: Single);
begin
  FdLifetimeVariation.Send(Value);
end;

function TParticleSystemNode.GetMaxParticles: Integer;
begin
  Result := FdMaxParticles.Value;
end;

procedure TParticleSystemNode.SetMaxParticles(const Value: Integer);
begin
  FdMaxParticles.Send(Value);
end;

function TParticleSystemNode.GetParticleLifetime: Single;
begin
  Result := FdParticleLifetime.Value;
end;

procedure TParticleSystemNode.SetParticleLifetime(const Value: Single);
begin
  FdParticleLifetime.Send(Value);
end;

function TParticleSystemNode.GetParticleSize: TVector2Single;
begin
  Result := FdParticleSize.Value;
end;

procedure TParticleSystemNode.SetParticleSize(const Value: TVector2Single);
begin
  FdParticleSize.Send(Value);
end;

{$endif read_implementation}
