{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetFilled: boolean;
    procedure SetFilled(const Value: boolean);
    function GetHatchColor: TCastleColorRGB;
    procedure SetHatchColor(const Value: TCastleColorRGB);
    function GetHatched: boolean;
    procedure SetHatched(const Value: boolean);
    function GetHatchStyle: Integer;
    procedure SetHatchStyle(const Value: Integer);
  public
    property Filled: boolean read GetFilled write SetFilled;
    property HatchColor: TCastleColorRGB read GetHatchColor write SetHatchColor;
    property Hatched: boolean read GetHatched write SetHatched;
    property HatchStyle: Integer read GetHatchStyle write SetHatchStyle;

{$endif read_interface}

{$ifdef read_implementation}

{ TFillPropertiesNode ----------------------------------------------- }

function TFillPropertiesNode.GetFilled: boolean;
begin
  Result := FdFilled.Value;
end;

procedure TFillPropertiesNode.SetFilled(const Value: boolean);
begin
  FdFilled.Send(Value);
end;

function TFillPropertiesNode.GetHatchColor: TCastleColorRGB;
begin
  Result := FdHatchColor.Value;
end;

procedure TFillPropertiesNode.SetHatchColor(const Value: TCastleColorRGB);
begin
  FdHatchColor.Send(Value);
end;

function TFillPropertiesNode.GetHatched: boolean;
begin
  Result := FdHatched.Value;
end;

procedure TFillPropertiesNode.SetHatched(const Value: boolean);
begin
  FdHatched.Send(Value);
end;

function TFillPropertiesNode.GetHatchStyle: Integer;
begin
  Result := FdHatchStyle.Value;
end;

procedure TFillPropertiesNode.SetHatchStyle(const Value: Integer);
begin
  FdHatchStyle.Send(Value);
end;

{$endif read_implementation}
