{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetBottom: boolean;
    procedure SetBottom(const Value: boolean);
    function GetHeight: Single;
    procedure SetHeight(const Value: Single);
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
    function GetSide: boolean;
    procedure SetSide(const Value: boolean);
    function GetTop: boolean;
    procedure SetTop(const Value: boolean);
    function GetSlices: Integer;
    procedure SetSlices(const Value: Integer);
    function GetStacks: Integer;
    procedure SetStacks(const Value: Integer);
  public
    property Bottom: boolean read GetBottom write SetBottom;
    property Height: Single read GetHeight write SetHeight;
    property Radius: Single read GetRadius write SetRadius;
    property Side: boolean read GetSide write SetSide;
    property Top: boolean read GetTop write SetTop;
    property Slices: Integer read GetSlices write SetSlices;
    property Stacks: Integer read GetStacks write SetStacks;

{$endif read_interface}

{$ifdef read_implementation}

{ TCylinderNode ----------------------------------------------- }

function TCylinderNode.GetBottom: boolean;
begin
  Result := FdBottom.Value;
end;

procedure TCylinderNode.SetBottom(const Value: boolean);
begin
  FdBottom.Send(Value);
end;

function TCylinderNode.GetHeight: Single;
begin
  Result := FdHeight.Value;
end;

procedure TCylinderNode.SetHeight(const Value: Single);
begin
  FdHeight.Send(Value);
end;

function TCylinderNode.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TCylinderNode.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

function TCylinderNode.GetSide: boolean;
begin
  Result := FdSide.Value;
end;

procedure TCylinderNode.SetSide(const Value: boolean);
begin
  FdSide.Send(Value);
end;

function TCylinderNode.GetTop: boolean;
begin
  Result := FdTop.Value;
end;

procedure TCylinderNode.SetTop(const Value: boolean);
begin
  FdTop.Send(Value);
end;

function TCylinderNode.GetSlices: Integer;
begin
  Result := FdSlices.Value;
end;

procedure TCylinderNode.SetSlices(const Value: Integer);
begin
  FdSlices.Send(Value);
end;

function TCylinderNode.GetStacks: Integer;
begin
  Result := FdStacks.Value;
end;

procedure TCylinderNode.SetStacks(const Value: Integer);
begin
  FdStacks.Send(Value);
end;

{$endif read_implementation}
