from twisted.internet import reactor
from twisted.spread import pb
from twisted.cred.credentials import Anonymous, UsernamePassword
from widget import WidgetState

class WaitForSeverState(WidgetState):
	def __init__(self):
		from widget import Label
		WidgetState.__init__(self)
		Label("Connecting to server", (None, None))

class ClientMind(pb.Referenceable):

	def __init__(self, client):
		self.client = client 
	
	def remote_get_client_info(self):
		info = {'game': self.client.game,
			'players': self.client.game.players}
		return info


class Client:

	def __init__(self, server_name):
		self.server_name = server_name
	
	def run(self, local_players):
		self.local_players = local_players

		self.wait_for_server_state = WaitForSeverState()

		factory = pb.PBClientFactory()
		reactor.connectTCP(self.server_name , pb.portno, factory)
		#factory.login(Anonymous()).addCallbacks(connected, failure)
		d = factory.login(UsernamePassword("guest", "guest"), ClientMind(self))
		d.addCallbacks(self.connected_callback, self.failure_callback)

	##### callbacks

	def connected_callback(self, perspective):
		print "connected."
		self.perspective = perspective
		d = self.perspective.callRemote('get_server_info')
		d.addCallback(self.get_server_info_callback)
		d.addCallback(self.fetch_players_callback)
		d.addCallback(self.send_ready_callback)

	def send_ready_callback(self, dummy):
		self.perspective.callRemote('client_ready')

	def failure_callback(self, error):
		print "login failure:", error

	def get_server_info_callback(self, info):
		import game
		self.game = game.Game(info['number_of_players'])
		self.game.run_callback = self.wait_for_server_state.quit

	def fetch_players_callback(self, dummy):
		
		def player_fetched(player_id, avatar):
			self.game.players[player_id].avatar = avatar
			self.game.players[player_id].local = True
			print "got player %d!" % player_id

		for i in range(self.local_players):
			d = self.perspective.callRemote('get_player')
			d.addCallback(lambda args: player_fetched(*args))


