/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "memory.h"

GList *
mem_free_1(GList *stack, gpointer data)
{
	GList *item = NULL;
	
	item = g_list_find(stack, data);
	stack = g_list_remove_link(stack, item);
	free(data);
	g_list_free_1(item);
	
	return g_list_first(stack);
}

GList *
mem_free(GList *stack)
{
	GList *item = NULL;
	
	item = g_list_first(stack);
	while(item)
	{
		free(item->data);
		item = item->next;
	}
	g_list_free(stack);
	
	return NULL;
}



