/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define MAX_TRACKS 99

typedef struct CDTrack_s
{
	char number[20];
	char title[2048];
	char filename[2048];
} CDTrack;

typedef struct CDInfo_s
{
	unsigned long id;
	int tracks;
	unsigned long track_offset[100];
	int seconds;
	char genre[512];
	char cdtitle[1024];
	void *track[MAX_TRACKS];
	char year[20];
} CDInfo;

/* Prototypes */
int freedb_connect_host(char *hostname, unsigned int host_port, char *proxy, unsigned int proxy_port);
int freedb_get_album_by_id_and_category(int socket_number, char *hostname, unsigned int host_port, char *cgi_path, char *progname, char *version, CDInfo **cd);
int freedb_get_albumlist_by_searchstring(int socket_number, char *pstring, GList **cdlist);
