/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "support.h"

#include "memory.h"
#include "mp3info.h"
#include "gui_queue.h"

/**********************************************************************
 * Add a list of files to a queue list
 * Arguments: A list of files.
 * Returns: The number of files added
 **********************************************************************/
gint
clist_queue_add_files(GtkCList *clist, GList **rows, GList *orderlist)
{
	gchar *outputrow[30];
	Mp3Info *queuerow = NULL;
	GList *temprowdata = NULL;
	GList *item = NULL;
	GList *tempitem = NULL;
	GList *orderlistitem = NULL;
	gchar *order = NULL;
	
	gint column = 0, i = 0;
	gint added_rows = 0;

	if(!*rows)
		return added_rows;
	
	gtk_clist_freeze(clist);
	
	item = g_list_first (*rows);
	while(item)
	{
		queuerow = (Mp3Info *)item->data;
		
		for(i=0; i<=29; i++)
			outputrow[i] = NULL;
		
		column = -1;
		orderlistitem = g_list_first (orderlist);
		while(orderlistitem)
		{
			++column;
			order = (gchar *)orderlistitem->data;
			
			if( strncmp(order, "Directory", 9) == 0 )
				outputrow[column] = queuerow->directory;
			if(strncmp(order, "Destinationname", 16) == 0)
				outputrow[column] = queuerow->destinationfilename;
			if( strncmp(order, "Filename", 8) == 0 )
				outputrow[column] = queuerow->filename;
			
			if(strncmp(order, "Size", 4) == 0)
			{
				temprowdata = g_list_append(temprowdata, outputrow[column] = malloc(2048));
				sprintf(outputrow[column], "%lu", queuerow->filesize);
			}
			if(strncmp(order, "Owner", 5) == 0)
				outputrow[column] = queuerow->owner;
			if(strncmp(order, "Group", 5) == 0)
				outputrow[column] = queuerow->group;
			if(strncmp(order, "Mode", 4) == 0)
				outputrow[column] = queuerow->mode;

// V1 tag fields
			if(strncmp(order, "V1-Artist", 6) == 0)
				outputrow[column] = queuerow->v1_artist;
			if(strncmp(order, "V1-Song", 5) == 0)
				outputrow[column] = queuerow->v1_title;
			if(strncmp(order, "V1-Album", 5) == 0)
				outputrow[column] = queuerow->v1_album;
			if(strncmp(order, "V1-Year", 4) == 0)
				outputrow[column] = queuerow->v1_year;
			if(strncmp(order, "V1-Comment", 7) == 0)
				outputrow[column] = queuerow->v1_comment;
			if(strncmp(order, "V1-Track", 6) == 0)
				outputrow[column] = queuerow->v1_track;
			if(strncmp(order, "V1-Genre", 5) == 0)
				outputrow[column] = queuerow->v1_genre;
			
// V2 tag fields
			if(strncmp(order, "V2-Artist", 6) == 0)
				outputrow[column] = queuerow->v2_artist;
			if(strncmp(order, "V2-Song", 5) == 0)
				outputrow[column] = queuerow->v2_title;
			if(strncmp(order, "V2-Album", 5) == 0)
				outputrow[column] = queuerow->v2_album;
			if(strncmp(order, "V2-Year", 4) == 0)
				outputrow[column] = queuerow->v2_year;
			if(strncmp(order, "V2-Comment", 7) == 0)
				outputrow[column] = queuerow->v2_comment;
			if(strncmp(order, "V2-Track", 6) == 0)
				outputrow[column] = queuerow->v2_track;
			if(strncmp(order, "V2-Genre", 5) == 0)
				outputrow[column] = queuerow->v2_genre;
			
// Vorbis tag fields
			if(strncmp(order, "Ogg-Artist", 13) == 0)
				outputrow[column] = queuerow->ogg_artist;
			if(strncmp(order, "Ogg-Song", 11) == 0)
				outputrow[column] = queuerow->ogg_title;
			if(strncmp(order, "Ogg-Album", 12) == 0)
				outputrow[column] = queuerow->ogg_album;
			if(strncmp(order, "Ogg-Year", 11) == 0)
				outputrow[column] = queuerow->ogg_year;
			if(strncmp(order, "Ogg-Comment", 13) == 0)
				outputrow[column] = queuerow->ogg_comment;
			if(strncmp(order, "Ogg-Track", 11) == 0)
				outputrow[column] = queuerow->ogg_track;
			if(strncmp(order, "Ogg-Genre", 11) == 0)
				outputrow[column] = queuerow->ogg_genre;
			
// others
			if(strncmp(order, "Status", 6) == 0)
				outputrow[column] = queuerow->status;
			if(strncmp(order, "Time", 6) == 0)
			{
				temprowdata = g_list_append(temprowdata, outputrow[column] = malloc(2048));
				if((int)queuerow->seconds-( ((int)queuerow->seconds/60)*60)<10)
					snprintf(outputrow[column], 2047, "%i:0%i", (int)queuerow->seconds/60, (int)queuerow->seconds-( ((int)queuerow->seconds/60)*60));
				else
					snprintf(outputrow[column], 2047, "%i:%i", (int)queuerow->seconds/60, (int)queuerow->seconds-( ((int)queuerow->seconds/60)*60));
			}

			orderlistitem = orderlistitem->next;
		}

// If the row that we want to add doesn't contain a filename, just remove it from the list.
// This happens in case of some errors. (e.g. file could not be stated)
		if(queuerow->filename
			&& *queuerow->filename != '\0')
		{
			gtk_clist_set_row_data(clist, gtk_clist_append(clist, outputrow), queuerow);
			item = item->next;
		}
		else
		{
			tempitem = item;
			item = item->next;
			*rows = mem_free_1(*rows, tempitem->data);
		}

		mem_free(temprowdata);
    temprowdata = NULL;
	}
	
// Cleanups
	gtk_clist_sort(clist);
	gtk_clist_columns_autosize(clist);
	gtk_clist_thaw(clist);
	return added_rows;
}










/**********************************************************************
 * Set the column titles of clist to values stored in order.
 * Unused (NULL) items will be set invisible
 **********************************************************************/
void
clist_set_titles(GtkCList *clist, GList *orderlist)
{
	gint column = 0;
	
	if( !orderlist )
		return;
	
// Hide all columns (we must keep one visible)
	for(column = 1; column <= 29; column++)
		gtk_clist_set_column_visibility(clist, column, FALSE);
	
// set the title of the still visible column.
	gtk_clist_set_column_title(clist, 0, (gchar *)orderlist->data);
	
// And make only those visible again, which are given in "order" and set their titles
	column = 0;
	while(orderlist)
	{
		gtk_clist_set_column_visibility(clist, column, TRUE);
		gtk_clist_set_column_title(clist, column, (gchar *)orderlist->data);
		
		column++;
		orderlist = orderlist->next;
	}
}







/**********************************************************************
 * Toggle the rows bg colors.
 **********************************************************************/
void
clist_queue_toggle_colors(GtkCList *clist)
{
	gint row = -1;
	GdkColor grey = {0, 0xeeee, 0xeeee, 0xeeee};
	GdkColor white = {0, 0xffff, 0xffff, 0xffff};
	gboolean colorize = TRUE;

	while( gtk_clist_get_selectable(clist, ++row) )
	{
		if(colorize)
		{
			GtkStyle *style = NULL;
			
			if( gtk_clist_get_row_style(clist, row) != NULL )
			{
				style = gtk_style_copy(gtk_clist_get_row_style(clist, row));
				style->base[GTK_STATE_NORMAL] = grey;
				gtk_clist_set_row_style(clist, row, style);
			}
			else
			{
				style = gtk_style_new();
				style->base[GTK_STATE_NORMAL] = grey;
				gtk_clist_set_row_style(clist, row, style);
			}
			gtk_style_unref(style);

			colorize = FALSE;
		}
		else
		{
			GtkStyle *style = NULL;
			
			if( gtk_clist_get_row_style(clist, row) != NULL )
			{
				style = gtk_style_copy(gtk_clist_get_row_style(clist, row));
				style->base[GTK_STATE_NORMAL] = white;
				gtk_clist_set_row_style(clist, row, style);
			}
			else
			{
				style = gtk_style_new();
				style->base[GTK_STATE_NORMAL] = white;
				gtk_clist_set_row_style(clist, row, style);
			}
			gtk_style_unref(style);

			colorize = TRUE;
		}
	}
}



/**********************************************************************
 * Remove the rows in "rows" from the clist "clist".
 **********************************************************************/
void
clist_files_remove(GtkCList *clist, GList *rows)
{
	Mp3Info *mp3info = NULL;
	GList *item = NULL;
	GtkStyle *styleold = NULL;
	gint row = 0;
	
	item = rows;
	while(item)
	{
		mp3info = (Mp3Info *)item->data;
		row = gtk_clist_find_row_from_data(clist, mp3info);

// free the style
		styleold = gtk_clist_get_row_style(clist, row);
		if( styleold != NULL )
			gtk_style_unref(styleold);
		
// remove row
		gtk_clist_remove(clist, row);
		
		item = item->next;
	}
}






/**********************************************************************
 * Update ONE row in the clist "clist".
 **********************************************************************/
void
clist_file_update(GtkCList *clist, Mp3Info *mp3info)
{
	gint row = 0, column = -1;
	gchar *outputrow[30];
	GList *temprowdata = NULL;
	gchar *title = NULL;
	GtkStyle *style = NULL;

// Find row
	if( (row = gtk_clist_find_row_from_data(clist, mp3info)) < 0 )
		return;
	
// Init variables
	for(column = 0; column <= 29; column++)
		outputrow[column] = NULL;
	
	gtk_clist_freeze(clist);

// Save the background color of the old row
	style = gtk_style_copy(gtk_clist_get_row_style(clist, row));
	
// remove row.	
	gtk_clist_remove(clist, row);

// prepare the updated row.
	column = -1;
	while( (title = gtk_clist_get_column_title(clist, ++column)) )
	{
		if(strncmp(title, "Directory", 9)==0)
			outputrow[column] = mp3info->directory;
		if(strncmp(title, "Destinationname", 16)==0)
			outputrow[column] = mp3info->destinationfilename;
		if(strncmp(title, "Filename", 8)==0)
			outputrow[column] = mp3info->filename;
		
		if(strncmp(title, "Size", 4)==0)
		{
			temprowdata = g_list_append(temprowdata, outputrow[column] = malloc(2048));
			sprintf(outputrow[column], "%lu", mp3info->filesize);
		}
		if(strncmp(title, "Owner", 5)==0)
			outputrow[column] = mp3info->owner;
		if(strncmp(title, "Group", 5)==0)
			outputrow[column] = mp3info->group;
		if(strncmp(title, "Mode", 4)==0)
			outputrow[column] = mp3info->mode;

// V1 tag fields
		if(strncmp(title, "V1-Artist", 6)==0)
			outputrow[column] = mp3info->v1_artist;
		if(strncmp(title, "V1-Song", 5)==0)
			outputrow[column] = mp3info->v1_title;
		if(strncmp(title, "V1-Album", 5)==0)
			outputrow[column] = mp3info->v1_album;
		if(strncmp(title, "V1-Year", 4)==0)
			outputrow[column] = mp3info->v1_year;
		if(strncmp(title, "V1-Comment", 7)==0)
			outputrow[column] = mp3info->v1_comment;
		if(strncmp(title, "V1-Track", 6)==0)
			outputrow[column] = mp3info->v1_track;
		if(strncmp(title, "V1-Genre", 5)==0)
			outputrow[column] = mp3info->v1_genre;
		
// V2 tag fields
		if(strncmp(title, "V2-Artist", 6)==0)
			outputrow[column] = mp3info->v2_artist;
		if(strncmp(title, "V2-Song", 5)==0)
			outputrow[column] = mp3info->v2_title;
		if(strncmp(title, "V2-Album", 5)==0)
			outputrow[column] = mp3info->v2_album;
		if(strncmp(title, "V2-Year", 4)==0)
			outputrow[column] = mp3info->v2_year;
		if(strncmp(title, "V2-Comment", 7)==0)
			outputrow[column] = mp3info->v2_comment;
		if(strncmp(title, "V2-Track", 6)==0)
			outputrow[column] = mp3info->v2_track;
        if(strncmp(title, "V2-Genre", 5) == 0)
			outputrow[column] = mp3info->v2_genre;
		
// Ogg tag fields
		if(strncmp(title, "Ogg-Artist", 13)==0)
			outputrow[column] = mp3info->ogg_artist;
		if(strncmp(title, "Ogg-Song", 11)==0)
			outputrow[column] = mp3info->ogg_title;
		if(strncmp(title, "Ogg-Album", 12)==0)
			outputrow[column] = mp3info->ogg_album;
		if(strncmp(title, "Ogg-Year", 11)==0)
			outputrow[column] = mp3info->ogg_year;
		if(strncmp(title, "Ogg-Comment", 13)==0)
			outputrow[column] = mp3info->ogg_comment;
		if(strncmp(title, "Ogg-Track", 11)==0)
			outputrow[column] = mp3info->ogg_track;
		if(strncmp(title, "Ogg-Genre", 11)==0)
			outputrow[column] = mp3info->ogg_genre;
		
// other
		if( strncmp(title, "Status", 6) == 0 )
			outputrow[column] = mp3info->status;
		if( strncmp(title, "Time", 6) == 0 )
		{
			temprowdata = g_list_append(temprowdata, outputrow[column] = malloc(2048));
			if((int)mp3info->seconds-( ((int)mp3info->seconds/60)*60)<10)
				sprintf(outputrow[column], "%i:0%i", (int)mp3info->seconds/60, (int)mp3info->seconds-( ((int)mp3info->seconds/60)*60));
			else
				sprintf(outputrow[column], "%i:%i", (int)mp3info->seconds/60, (int)mp3info->seconds-( ((int)mp3info->seconds/60)*60));
		}
	}
	
// and insert the row again.
	gtk_clist_insert(clist, row, outputrow);
	gtk_clist_set_row_data(clist, row, mp3info);
	
	gtk_clist_set_row_style(clist, row, style);
	gtk_style_unref(style);
	
	gtk_clist_thaw(clist);
	mem_free(temprowdata);
}
