/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


typedef struct cfg_s
{
	GList *qcols;
	gboolean hidesplash;
	gboolean showhidden;
	gboolean togglequeuebg;
	gint defaulttag;
	gchar defaultdir[4096];
	gchar homedir[4096];
} Cfg;

void get_config_to_struct (Cfg *cfg);
void destroy_config (Cfg *cfg);
/*
 * This function will read the complete configfile into a config variable
 */
gint config_read(gchar *config, gint maxsize);

/*
 * This function will grab the value of one option out of the config variable
 */
gboolean configfile_option_get(gchar *config, gchar *category, gchar *option, gchar *value);

/*
 * This function will add one option to the config variable
 */
gboolean configfile_option_add(gchar *config, gchar *category, gchar *option, gchar *value);

/*
 * This function will remove one complete category (and its contents) from the config variable
 */
gboolean configfile_category_remove(gchar *config, gchar *category);

/*
 * This function will write the complete config variable to the config file.
 */
gint config_write(gchar *config);

/*
 * This function checks, if a configfile exists. If it does, it will check for validity,
 * otherwise it will try to create a new one.
 */
gboolean configfile_check(gchar *configfilename, gchar *mustbeversion);

/*
 * This function will write a default config file.
 */
gboolean configfile_set_default(void);
