/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef MEDICAL_DATA_ORIGIN_H
#define MEDICAL_DATA_ORIGIN_H

// -- Core image component stuff
#include "ui_MedicalDataOriginDialog.h"




namespace camitk
{
  
  // -- Core image component stuff classes
class ImageComponent;

// -- Core stuff
class InteractiveViewer;
//***************************************************************************

/**
 * @ingroup group_sdk_libraries_core_component_image
 * 
 * @brief
 * The class ImageReconstructionAction interfaces the reconstruction
 * of 3D volumes from a set of images (ImageComponent), typically using the marching cubes algorithm.
 */
class MedicalDataOriginDialog : public QDialog {
    Q_OBJECT

  public:

    /// Default construtor
    MedicalDataOriginDialog(ImageComponent *, QWidget* parent = 0);
		/// Destructor 
		~MedicalDataOriginDialog();

    /// Initialize the dialog options.
    void init();

  public slots:

    /// Reimplemented from uic_MedicalDataOriginDialog. Applies the new origin on the image data.
    virtual void applyOrigin();

		/// Reimplemented from uic_MedicalDataOriginDialog. Display an PNG image representing the desired origin.
    virtual void displayOrigin( int i );

  private:
    /// The Component concerned by the change of origin.
    ImageComponent * myComponent;

    // QDialog designed by QtDesigner (with qt4, nor more inheritance from the ui)
		Ui::MedicalDataOriginDialog ui;

};

}

//**************************************************************************
#endif   /// MEDICAL_DATA_ORIGIN_H
