/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef RAW_IMAGE_COMPONENT_H
#define RAW_IMAGE_COMPONENT_H


// -- raw data image component stuff
#include "RawDataDialog.h"

// -- Core image component stuff
#include <ImageComponent.h>

// -- VTK stuff
#include <vtkSmartPointer.h>
#include <vtkImageData.h>
/**
 * @ingroup group_sdk_components_vtkimage
 * 
 * @brief 
 * This class manage raw images, i.e., images that are directly loaded from a file containing only the binary values of the voxels.
 * The user has to fill a form in order to describe the parameters (volume and voxel sizes, binary type...)
 * 
 **/ 
class RawImageComponent : public camitk::ImageComponent  {
    Q_OBJECT
public:
    /// default constructor: give it the name of the file containing the data
    RawImageComponent(const QString&) throw (camitk::AbortException);

    /// Destructor
    ~RawImageComponent();

    virtual void createComponent();

    void createDialog();

protected:
    RawDataDialog * myDialog;

};



#endif // RAW_IMAGE_COMPONENT_H
