# To run this script independently use
# cd . && ctest -S CamiTKTestBuild.cmake -O /tmp/ctest.log -VV

# Directory that will be used as top directory for src, build, and install dir (/opt/build, /tmp...)
set(CAMITK_TEST_BUILD_ROOT "/opt/camitkbuild" CACHE PATH "top directory for src, build, and install dir")
# svn repository root 
set(CAMITK_SVN_TRUNK "svn+ssh://svn-timc.imag.fr/svn/gmcao/camitk/trunk" CACHE STRING "")
# root of mingw crosscompile environment installation
set(MINGW32_CROSS_ENV "/opt/mingw" CACHE PATH "")

# the macro is defined somewhere else
include(./CamiTKTestBuildMacros.cmake)

#-- build option for a as nearly as possible full camitk compilation
set(CAMITK_FLAGS_BASE "-DAPPLICATION_BASIC:BOOL=ON
                      -DAPPLICATION_SIMPLE:BOOL=ON
                      -DAPPLICATION_FANCY:BOOL=ON
                      -DAPPLICATION_OBJECTCONTROLLER:BOOL=ON
                      -DCOMPONENT_PHYSICALMODEL:BOOL=ON
                      -DMODULES_ANIMATION_MOTOR_INCOMPRESSIBILITY:BOOL=ON
                      -DCOMPONENT_PHYSICALMODEL_SOFA_SUPPORT:BOOL=OFF "
)
# TODO solve problem with camera (compilation under mingw32) and then add this to CAMITK_FLAGS_BASE:
#  -DCOMPONENT_CAMERA:BOOL=ON \
# TODO solve problem with SOFA or remove SOFA support in PML

# depends on xerces
set(CAMITK_FLAGS_XERCES_DEP "-DCOMPONENT_MML:BOOL=ON ")
set(CAMITK_FLAGS_XSDCXX_DEP "-DMML_GENERATE_XSD_LIB:BOOL=ON ")

# depends on itk
set(CAMITK_FLAGS_ITK_DEP "-DCOMPONENT_DICOM:BOOL=ON
                          -DCOMPONENT_ITKIMAGE:BOOL=ON
                          -DMODULES_ITK_IMAGE_FILTERS:BOOL=ON "
)

# depends on opencv (libcv-dev libhighgui-dev libcvaux-dev)
set(CAMITK_FLAGS_OPENCV_DEP "-DCOMPONENT_DISTRIBUTEDENDOSCOPY:BOOL=ON ")
# TODO add cameracalibration module OpenCV Addon

set(CAMITK_NATIVE_FLAGS "${CAMITK_FLAGS_BASE} ${CAMITK_FLAGS_ITK_DEP} ${CAMITK_FLAGS_XERCES_DEP} ${CAMITK_FLAGS_XSDCXX_DEP} ${CAMITK_FLAGS_OPENCV_DEP}")

# TODO win32 compile ITK and add CAMITK_FLAGS_ITK_DEP to the crosscompilation
# TODO win32 install code synthesis xsd and add this to CAMITK_CROSSCOMPILE_FLAGS
#         $CAMITK_FLAGS_XERCES_DEP \
#         -DMML_GENERATE_XSD_LIB:BOOL=OFF 
set(CAMITK_WIN32_FLAGS "-DVTK_DIR=${CAMITK_TEST_BUILD_ROOT}/install-win32/lib/vtk-5.6 ${CAMITK_FLAGS_BASE} ")

#-- test the native build
##camitk_test_build(camitk-svn native camitk/src "${CAMITK_NATIVE_FLAGS}" )
##camitk_test_build(myextension-svn native myextension "") # no specific flags needed

#-- test the win32 build
camitk_test_build(camitk-svn win32 camitk/src "${CAMITK_WIN32_FLAGS}" )
camitk_test_build(myextension-svn win32 myextension "") # no specific flags needed

